/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.LibraryFile;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Application")
public class FXManifest {
    @XmlAttribute
    URI uri;
    @XmlAttribute(name="launch")
    String launchClass;
    @XmlElement(name="lib")
    List<LibraryFile> files = new ArrayList<LibraryFile>();
    @XmlElement
    String updateText = "Updating...";
    @XmlElement
    String updateLabelStyle = "-fx-font-weight: bold;";
    @XmlElement
    String progressBarStyle = "-fx-pref-width: 200;";
    @XmlElement
    String wrapperStyle = "-fx-spacing: 10; -fx-padding: 25;";
    @XmlElement
    String parameters;

    public String getFilename() {
        return String.format("%s.xml", this.launchClass);
    }

    public URI getFXAppURI() {
        return this.uri.resolve("app.xml");
    }

    public Path getPath() {
        return Paths.get(this.getFilename(), new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FXManifest that = (FXManifest)o;
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.launchClass != null ? !this.launchClass.equals(that.launchClass) : that.launchClass != null) {
            return false;
        }
        if (this.files != null ? !this.files.equals(that.files) : that.files != null) {
            return false;
        }
        if (this.updateText != null ? !this.updateText.equals(that.updateText) : that.updateText != null) {
            return false;
        }
        if (this.updateLabelStyle != null ? !this.updateLabelStyle.equals(that.updateLabelStyle) : that.updateLabelStyle != null) {
            return false;
        }
        if (this.progressBarStyle != null ? !this.progressBarStyle.equals(that.progressBarStyle) : that.progressBarStyle != null) {
            return false;
        }
        return this.wrapperStyle != null ? this.wrapperStyle.equals(that.wrapperStyle) : that.wrapperStyle == null;
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.launchClass != null ? this.launchClass.hashCode() : 0);
        result = 31 * result + (this.files != null ? this.files.hashCode() : 0);
        result = 31 * result + (this.updateText != null ? this.updateText.hashCode() : 0);
        result = 31 * result + (this.updateLabelStyle != null ? this.updateLabelStyle.hashCode() : 0);
        result = 31 * result + (this.progressBarStyle != null ? this.progressBarStyle.hashCode() : 0);
        result = 31 * result + (this.wrapperStyle != null ? this.wrapperStyle.hashCode() : 0);
        return result;
    }
}

