/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.OS;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import javax.xml.bind.annotation.XmlAttribute;

public class LibraryFile {
    @XmlAttribute
    String file;
    @XmlAttribute
    Long checksum;
    @XmlAttribute
    Long size;
    @XmlAttribute
    OS os;

    public boolean needsUpdate() {
        Path path = Paths.get(this.file, new String[0]);
        try {
            return !Files.exists(path, new LinkOption[0]) || Files.size(path) != this.size || LibraryFile.checksum(path) != this.checksum;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LibraryFile() {
    }

    public LibraryFile(Path basepath, Path file) throws IOException {
        this.file = basepath.relativize(file).toString();
        this.size = Files.size(file);
        this.checksum = LibraryFile.checksum(file);
        String filename = file.getFileName().toString().toLowerCase();
        Pattern osPattern = Pattern.compile(".*-(linux|win|mac).jar");
        Matcher osMatcher = osPattern.matcher(filename);
        if (osMatcher.matches()) {
            this.os = OS.valueOf(osMatcher.group(1));
        }
    }

    public boolean loadForCurrentPlatform() {
        return this.os == null || this.os == OS.current;
    }

    public URL toURL() {
        try {
            return Paths.get(this.file, new String[0]).toFile().toURI().toURL();
        }
        catch (MalformedURLException whaat) {
            throw new RuntimeException(whaat);
        }
    }

    public static long checksum(Path path) throws IOException {
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            int read;
            Adler32 checksum = new Adler32();
            byte[] buf = new byte[16384];
            while ((read = input.read(buf)) > -1) {
                checksum.update(buf, 0, read);
            }
            long l = checksum.getValue();
            return l;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryFile that = (LibraryFile)o;
        if (!this.file.equals(that.file)) {
            return false;
        }
        if (!this.checksum.equals(that.checksum)) {
            return false;
        }
        return this.size.equals(that.size);
    }

    public int hashCode() {
        int result = this.file.hashCode();
        result = 31 * result + this.checksum.hashCode();
        result = 31 * result + this.size.hashCode();
        return result;
    }
}

