/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.FXManifest;
import fxlauncher.LibraryFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.xml.bind.JAXB;

public class CreateManifest {
    public static void main(String[] args) throws IOException {
        URI baseURI = URI.create(args[0]);
        String launchClass = args[1];
        Path appPath = Paths.get(args[2], new String[0]);
        String name = args[3];
        FXManifest manifest = CreateManifest.create(baseURI, launchClass, appPath, name);
        JAXB.marshal((Object)manifest, (File)appPath.resolve("fxapp.xml").toFile());
    }

    public static FXManifest create(URI baseURI, String launchClass, final Path appPath, String name) throws IOException {
        final FXManifest manifest = new FXManifest();
        manifest.uri = baseURI;
        manifest.launchClass = launchClass;
        manifest.name = name;
        Files.walkFileTree(appPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!Files.isDirectory(file, new LinkOption[0]) && file.toString().endsWith(".jar")) {
                    manifest.files.add(new LibraryFile(appPath, file));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return manifest;
    }
}

