/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.FXManifest;
import fxlauncher.LibraryFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.xml.bind.JAXB;

public class Launcher
extends Application {
    private static FXManifest manifest;
    private static Application app;
    private static boolean offline;

    public void start(Stage primaryStage) throws Exception {
        ProgressBar progressBar = new ProgressBar();
        progressBar.setStyle(Launcher.manifest.progressBarStyle);
        Label label = new Label(Launcher.manifest.updateText);
        label.setStyle(Launcher.manifest.updateLabelStyle);
        VBox wrapper = new VBox(new Node[]{label, progressBar});
        wrapper.setStyle(Launcher.manifest.wrapperStyle);
        Scene scene = new Scene((Parent)wrapper);
        Stage stage = new Stage(StageStyle.UNDECORATED);
        stage.setScene(scene);
        stage.setTitle(Launcher.manifest.name);
        stage.show();
        Task sync = this.sync();
        progressBar.progressProperty().bind((ObservableValue)sync.progressProperty());
        sync.setOnSucceeded(e -> {
            try {
                app = this.launch(primaryStage);
                stage.close();
            }
            catch (Exception initError) {
                Launcher.reportError("Launch", initError);
            }
        });
        sync.setOnFailed(e -> Launcher.reportError("Sync", sync.getException()));
        new Thread((Runnable)sync).start();
    }

    public URLClassLoader createClassLoader() {
        List<URL> libs = Launcher.manifest.files.stream().map(LibraryFile::toURL).collect(Collectors.toList());
        return new URLClassLoader(libs.toArray(new URL[libs.size()]));
    }

    public Application launch(Stage primaryStage) throws Exception {
        URLClassLoader classLoader = this.createClassLoader();
        Class<?> appclass = classLoader.loadClass(Launcher.manifest.launchClass);
        Thread.currentThread().setContextClassLoader(classLoader);
        Application app = (Application)appclass.newInstance();
        app.init();
        app.start(primaryStage);
        return app;
    }

    public Task sync() throws IOException {
        return new Task(){

            protected Object call() throws Exception {
                if (offline) {
                    return null;
                }
                List needsUpdate = manifest.files.stream().filter(LibraryFile::needsUpdate).collect(Collectors.toList());
                Long totalBytes = needsUpdate.stream().mapToLong(f -> f.size).sum();
                Long totalWritten = 0L;
                for (LibraryFile lib : needsUpdate) {
                    this.updateMessage(lib.file.concat("..."));
                    Path target = Paths.get(lib.file, new String[0]).toAbsolutePath();
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    InputStream input = manifest.uri.resolve(lib.file).toURL().openStream();
                    Throwable throwable = null;
                    try {
                        OutputStream output = Files.newOutputStream(target, new OpenOption[0]);
                        Throwable throwable2 = null;
                        try {
                            int read;
                            byte[] buf = new byte[65536];
                            while ((read = input.read(buf)) > -1) {
                                output.write(buf, 0, read);
                                totalWritten = totalWritten + (long)read;
                                this.updateProgress(totalWritten, totalBytes);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (output == null) continue;
                            if (throwable2 != null) {
                                try {
                                    output.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            output.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                try (ByteArrayOutputStream mfstream = new ByteArrayOutputStream();){
                    JAXB.marshal((Object)manifest, (OutputStream)mfstream);
                    Path manifestPath = Paths.get("fxapp.xml", new String[0]);
                    byte[] data = mfstream.toByteArray();
                    if (Files.notExists(manifestPath, new LinkOption[0]) || !Arrays.equals(Files.readAllBytes(manifestPath), data)) {
                        Files.write(manifestPath, data, new OpenOption[0]);
                    }
                }
                return null;
            }
        };
    }

    public void stop() throws Exception {
        if (app != null) {
            app.stop();
        }
    }

    private static void reportError(String job, Throwable error) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(String.format(Launcher.manifest.errorTitle, job));
        alert.setHeaderText(String.format(Launcher.manifest.errorHeader, job));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out);
        error.printStackTrace(writer);
        writer.close();
        alert.setContentText(out.toString());
        alert.showAndWait();
        Platform.exit();
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            Launcher.loadManifest(URI.create(args[0]).resolve("fxapp.xml"));
        } else {
            try {
                URI localURI = Paths.get("fxapp.xml", new String[0]).toUri();
                Launcher.loadManifest(localURI);
            }
            catch (Exception ex) {
                manifest = new FXManifest();
                Launcher.manifest.errorHeader = String.format("Could not locate %s and no manifest uri parameter was given", "fxapp.xml");
                Launcher.launch((String[])new String[0]);
                Platform.runLater(() -> Launcher.reportError("Manifest load", ex));
                return;
            }
            try {
                Launcher.loadManifest(manifest.getFXAppURI());
            }
            catch (Exception networkError) {
                networkError.printStackTrace();
                offline = true;
            }
        }
        Launcher.launch((String[])new String[0]);
    }

    private static void loadManifest(URI uri) {
        manifest = (FXManifest)JAXB.unmarshal((URI)uri, FXManifest.class);
    }

    static {
        offline = false;
    }
}

