package no.tornado.inject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * <p>Annotate any beanProviderMethod with @Intercept("interceptorBean") to
 * reference another bean that must implement the Interceptor interface.</p>
 *
 * <p>The Interceptor#intercept() method will be called so you can intercept
 * all method calls in the proxied bean and even alter the returned object. This is
 * where you would add automatic transaction handling etc.</p>
 *
 * @see Interceptor
 *
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface Intercept {
    String value();
}
