package no.tornado.inject;

import java.lang.reflect.Method;

/**
 * <p>An interceptor will be called instead of the normal method invocation for proxied beans.
 * A typical scenario for an Interceptor is transaction handling:</p>
 *
 * <pre>
 * public Object intercept(Object bean, Method method, Object[] args) throws Exception {
 *      startTransaction();
 *      try {
 *          method.invoke(bean, args);
 *          commitTransaction();
 *      } catch (Exception ex) {
 *          rollbackTransaction();
 *      } finally {
 *          closeTransaction();
 *      }
 * }
 * </pre>
 *
 * The Interceptor, as any other bean, can enjoy depdendency injection via the @Inject annotation.
 *
 * @see Intercept
 */
public interface Interceptor {
    public Object intercept(Object bean, Method method, Object[] args) throws Exception;
}
