package no.tornado.inject;

import java.lang.reflect.Method;

public class DefaultCacheKeyGenerator implements CacheKeyGenerator {

    public String generate(String bean, Method method, Object[] args) {
        return bean + "." + method.getName() + "(" + argsSignature(args) + ")";
    }

    private String argsSignature(Object[] args) {
        if (args == null || args.length == 0)
            return "";
        
        StringBuilder s = new StringBuilder();
        for (Object arg : args) {
            if (s.length() > 0)
                s.append(",");
            s.append(arg == null ? "null" : arg.hashCode());
        }
        return s.toString();
    }

}
