package no.tornado.inject;

import java.lang.reflect.Method;

/**
 * <p>An interceptor will be called instead of the normal method invocation for proxied beans.
 * A typical scenario for an MethodInterceptor is transaction handling:</p>
 *
 * <pre>
 * public Object intercept(Object bean, Method method, Object[] args) throws Exception {
 *      startTransaction();
 *      try {
 *          method.invoke(bean, args);
 *          commitTransaction();
 *      } catch (Exception ex) {
 *          rollbackTransaction();
 *      } finally {
 *          closeTransaction();
 *      }
 * }
 * </pre>
 *
 * The MethodInterceptor, as any other bean, can enjoy depdendency injection via the @Inject annotation.
 *
 * @see Intercept
 */
public interface MethodInterceptor {
    public Object intercept(Object bean, Method method, Object[] args) throws Exception;
}
