/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import no.tornado.inject.BeanCreationException;
import no.tornado.inject.BeanInfo;
import no.tornado.inject.BeanNameAware;
import no.tornado.inject.BeanProxy;
import no.tornado.inject.CacheStore;
import no.tornado.inject.Destroy;
import no.tornado.inject.Ignore;
import no.tornado.inject.InitializingBean;
import no.tornado.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationContext {
    private static Logger logger = LoggerFactory.getLogger(ApplicationContext.class);
    private static Map<String, BeanInfo> beansByName = new HashMap<String, BeanInfo>();
    private static Map<Class, List<BeanInfo>> beansByClass = new HashMap<Class, List<BeanInfo>>();
    private static Timer cacheInvalidationTimer;

    public static void registerBeans(Object beanProvider) {
        Long before = new Date().getTime();
        Boolean cachesCreated = false;
        for (Method beanCreationMethod : ApplicationContext.getMethodsRecursive(beanProvider.getClass())) {
            if (beanCreationMethod.getAnnotation(Ignore.class) != null) {
                logger.debug("Ignoring bean " + beanCreationMethod.getName());
                continue;
            }
            logger.info("Registering bean " + beanCreationMethod.getName());
            BeanInfo beanInfo = new BeanInfo(beanCreationMethod, beanProvider);
            if (CacheStore.class.equals(beanCreationMethod.getReturnType())) {
                cachesCreated = true;
            }
            beansByName.put(beanInfo.getBeanName(), beanInfo);
            List<BeanInfo> beansBySameClass = beansByClass.get(beanInfo.getBeanCreationMethod().getReturnType());
            if (beansBySameClass == null) {
                beansBySameClass = new ArrayList<BeanInfo>();
                beansByClass.put(beanInfo.getBeanCreationMethod().getReturnType(), beansBySameClass);
            }
            beansBySameClass.add(beanInfo);
        }
        for (BeanInfo beanInfo : beansByName.values()) {
            if (!beanInfo.isEager()) continue;
            beanInfo.getBean();
        }
        if (cachesCreated.booleanValue() && cacheInvalidationTimer == null) {
            ApplicationContext.createCacheInvalidationTimer();
        }
        logger.info("Registered beans from " + beanProvider + " in " + (new Date().getTime() - before) + " ms");
    }

    private static void createCacheInvalidationTimer() {
        cacheInvalidationTimer = new Timer("CacheInvalidationTimer", true);
        cacheInvalidationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                List<CacheStore> cacheStores = ApplicationContext.getBeans(CacheStore.class);
                for (CacheStore cacheStore : cacheStores) {
                    cacheStore.invalidateExpired();
                }
            }
        }, 60000L, 60000L);
    }

    public static Object getBean(String beanName) {
        BeanInfo beanInfo = ApplicationContext.getBeanInfo(beanName);
        return beanInfo == null ? null : beanInfo.getBean();
    }

    public static <T> T getBean(Class<T> className) {
        List<BeanInfo> thisClassInfos = ApplicationContext.getBeanInfos(className);
        return (T)(thisClassInfos.isEmpty() ? null : ApplicationContext.getBeanInfos(className).get(0).getBean());
    }

    public static BeanInfo getBeanInfo(String beanName) {
        return beansByName.get(beanName);
    }

    public static <T> List<T> getBeans(Class<T> className) {
        ArrayList<Object> beans = new ArrayList<Object>();
        List<BeanInfo> beansByThisClass = beansByClass.get(className);
        if (beansByThisClass == null) {
            return new ArrayList();
        }
        for (BeanInfo beanInfo : beansByThisClass) {
            beans.add(beanInfo.getBean());
        }
        return beans;
    }

    public static List<BeanInfo> getBeanInfos(Class className) {
        return beansByClass.get(className);
    }

    public static void inject(final Object object) {
        BeanInfo mockBeanInfo = new BeanInfo(){

            @Override
            public String getBeanName() {
                return object.getClass().getName();
            }
        };
        ApplicationContext.injectMembers(mockBeanInfo, object);
    }

    static void postProcessBean(BeanInfo beanInfo, Object bean) {
        ApplicationContext.injectMembers(beanInfo, bean);
        if (bean instanceof InitializingBean) {
            ((InitializingBean)bean).afterPropertiesSet();
        }
        if (bean instanceof BeanNameAware) {
            ((BeanNameAware)bean).setBeanName(beanInfo.getBeanName());
        }
    }

    private static void injectMembers(BeanInfo beanInfo, Object bean) {
        logger.debug("Injecting members into " + beanInfo.getBeanName());
        for (Field field : ApplicationContext.getFieldsRecursive(bean.getClass())) {
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            field.setAccessible(true);
            if (inject.bean().equals("")) {
                logger.debug("Injecting " + beanInfo.getBeanName() + "." + field.getName() + " by className");
                List<?> beansByClassName = ApplicationContext.getBeans(field.getType());
                if (beansByClassName.isEmpty()) {
                    throw new BeanCreationException("Unable to inject " + beanInfo.getBeanName() + "." + field.getName() + ": No bean with type " + field.getType().getName() + " found in ApplicationContext", beanInfo);
                }
                try {
                    field.set(bean, beansByClassName.get(0));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new BeanCreationException("Unable to inject " + beanInfo.getBeanName() + "." + field.getName(), beanInfo, e);
                }
            }
            logger.debug("Injecting " + beanInfo.getBeanName() + "." + field.getName() + " by beanName");
            Object beanToInject = ApplicationContext.getBean(inject.bean());
            if (beanToInject == null) {
                throw new BeanCreationException("Unable to inject " + beanInfo.getBeanName() + "." + field.getName() + ": No bean with name " + inject.bean() + " found in ApplicationContext", beanInfo);
            }
            try {
                field.set(bean, beanToInject);
            }
            catch (IllegalAccessException e) {
                throw new BeanCreationException("Unable to inject " + beanInfo.getBeanName() + "." + field.getName(), beanInfo, e);
            }
        }
    }

    public static void shutdown() {
        new AppContextShutdownHook().run();
    }

    private static List<Field> getFieldsRecursive(Class beanClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ApplicationContext.addFieldsRecursive(fields, beanClass);
        return fields;
    }

    private static void addFieldsRecursive(List<Field> fields, Class beanClass) {
        fields.addAll(Arrays.asList(beanClass.getDeclaredFields()));
        if (beanClass.getSuperclass() != null) {
            ApplicationContext.addFieldsRecursive(fields, beanClass.getSuperclass());
        }
    }

    private static List<Method> getMethodsRecursive(Class beanClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ApplicationContext.addMethodsRecursive(methods, beanClass);
        return methods;
    }

    private static void addMethodsRecursive(List<Method> methods, Class beanClass) {
        methods.addAll(Arrays.asList(beanClass.getDeclaredMethods()));
        if (beanClass.getSuperclass() != null && !beanClass.getSuperclass().equals(Object.class)) {
            ApplicationContext.addMethodsRecursive(methods, beanClass.getSuperclass());
        }
    }

    private static List<Object> getBeanProviders() {
        ArrayList<Object> beanProviders = new ArrayList<Object>();
        for (BeanInfo info : beansByName.values()) {
            if (beanProviders.contains(info.getProvider())) continue;
            beanProviders.add(info.getProvider());
        }
        return beanProviders;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new AppContextShutdownHook());
    }

    private static class AppContextShutdownHook
    extends Thread {
        private AppContextShutdownHook() {
        }

        @Override
        public void run() {
            for (Object beanProvider : ApplicationContext.getBeanProviders()) {
                for (Method beanCreationMethod : beanProvider.getClass().getDeclaredMethods()) {
                    Destroy destroy = beanCreationMethod.getAnnotation(Destroy.class);
                    if (destroy == null) continue;
                    BeanInfo beanInfo = ApplicationContext.getBeanInfo(beanCreationMethod.getName());
                    Object bean = beanInfo.getBean();
                    if (Proxy.isProxyClass(bean.getClass())) {
                        BeanProxy lazyLoader = (BeanProxy)Proxy.getInvocationHandler(bean);
                        Object delegate = lazyLoader.getDelegate();
                        if (delegate == null) continue;
                        logger.info("Running destroy method " + delegate + " " + beanInfo.getBeanName() + "." + destroy.value() + "()");
                        try {
                            delegate.getClass().getMethod(destroy.value(), new Class[0]).invoke(delegate, new Object[0]);
                        }
                        catch (Exception ignored) {}
                        continue;
                    }
                    try {
                        logger.info("Running destroy method " + bean + "." + destroy.value() + "()");
                        bean.getClass().getMethod(destroy.value(), new Class[0]).invoke(bean, new Object[0]);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
            beansByName.clear();
            beansByClass.clear();
        }
    }
}

