/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import no.tornado.inject.ApplicationContext;
import no.tornado.inject.BeanCreationException;
import no.tornado.inject.BeanProxy;
import no.tornado.inject.Eager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInfo {
    private static Logger logger = LoggerFactory.getLogger(BeanInfo.class);
    private Method beanCreationMethod;
    private Object provider;
    private Object bean;

    BeanInfo() {
    }

    public BeanInfo(Method beanCreationMethod, Object provider) {
        this.beanCreationMethod = beanCreationMethod;
        this.provider = provider;
    }

    public boolean isEager() {
        return this.beanCreationMethod.getAnnotation(Eager.class) != null;
    }

    public Object getBean() {
        if (this.bean == null) {
            if (this.beanCreationMethod.getReturnType().isInterface()) {
                this.bean = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.beanCreationMethod.getReturnType()}, (InvocationHandler)new BeanProxy(this));
            } else {
                logger.info("Eagerly creating no-interface bean " + this.getBeanName());
                try {
                    this.bean = this.instantiate();
                }
                catch (InvocationTargetException ex) {
                    throw new BeanCreationException(this, ex.getCause() != null ? ex.getCause() : ex);
                }
                catch (IllegalAccessException ex) {
                    throw new BeanCreationException(this, (Throwable)ex);
                }
            }
        }
        return this.bean;
    }

    public Object instantiate() throws IllegalAccessException, InvocationTargetException {
        if (!this.beanCreationMethod.isAccessible()) {
            this.beanCreationMethod.setAccessible(true);
        }
        Object delegate = this.beanCreationMethod.invoke(this.provider, new Object[0]);
        ApplicationContext.postProcessBean(this, delegate);
        return delegate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BeanInfo) {
            return ((BeanInfo)obj).getBeanName().equals(this.getBeanName());
        }
        if (obj instanceof String) {
            return obj.equals(this.getBeanName());
        }
        return false;
    }

    public String getBeanName() {
        return this.beanCreationMethod.getName();
    }

    public Object getProvider() {
        return this.provider;
    }

    public void setProvider(Object provider) {
        this.provider = provider;
    }

    public Method getBeanCreationMethod() {
        return this.beanCreationMethod;
    }

    public void setBeanCreationMethod(Method beanCreationMethod) {
        this.beanCreationMethod = beanCreationMethod;
    }
}

