/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import no.tornado.inject.ApplicationContext;
import no.tornado.inject.BeanInfo;
import no.tornado.inject.Cache;
import no.tornado.inject.CacheIndex;
import no.tornado.inject.CacheStore;
import no.tornado.inject.Intercept;
import no.tornado.inject.InvalidateCaches;
import no.tornado.inject.MethodInterceptor;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProxy
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(BeanProxy.class);
    private static final PropertyUtilsBean propertyUtils = BeanUtilsBean2.getInstance().getPropertyUtils();
    private BeanInfo beanInfo;
    private Object delegate;
    private MethodInterceptor methodInterceptor;

    public BeanProxy(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object cachedResult;
        if (this.delegate == null) {
            logger.info("Lazily instantiating bean " + this.beanInfo.getBeanName());
            this.delegate = this.beanInfo.instantiate();
            Intercept intercept = this.beanInfo.getBeanCreationMethod().getAnnotation(Intercept.class);
            if (intercept != null) {
                this.methodInterceptor = (MethodInterceptor)ApplicationContext.getBean(intercept.value());
            }
        }
        method = this.getDelegateMethod(method);
        CacheStore cacheStore = null;
        String cacheKey = null;
        Cache cache = method.getAnnotation(Cache.class);
        if (cache != null && (cachedResult = (cacheStore = (CacheStore)ApplicationContext.getBean(cache.value())).lookup(cacheKey = cacheStore.getKeyGenerator().generate(this.beanInfo.getBeanName(), method, args))) != null) {
            return cachedResult;
        }
        try {
            Object result = this.methodInterceptor != null ? this.methodInterceptor.intercept(this.delegate, method, args) : method.invoke(this.delegate, args);
            Map<String, Serializable> cacheIndexes = this.getCacheIndexes(method, args);
            InvalidateCaches invalidateCaches = method.getAnnotation(InvalidateCaches.class);
            if (invalidateCaches != null) {
                for (String cacheName : invalidateCaches.value()) {
                    CacheStore cs = (CacheStore)ApplicationContext.getBean(cacheName);
                    if (cs == null) {
                        logger.error(this.beanInfo.getBeanName() + " is configured to invalidate non-existent cache " + cacheName);
                        continue;
                    }
                    if (cs.getCacheInterceptor() != null) {
                        cs.getCacheInterceptor().beforeInvalidate(this.beanInfo, method, args, cacheIndexes);
                    }
                    cs.invalidate(cacheIndexes);
                }
            }
            if (cacheKey != null && (result == null || result instanceof Serializable)) {
                if (cacheStore.getCacheInterceptor() != null) {
                    cacheStore.getCacheInterceptor().beforeStore(this.beanInfo, method, args, cacheIndexes, cacheKey);
                }
                Long expires = cache.expiresMinutes() == 0L ? null : Long.valueOf(new Date().getTime() + cache.expiresMinutes() * 60000L);
                cacheStore.store(cacheKey, (Serializable)result, cacheIndexes, expires);
            }
            return result;
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() != null) {
                throw ite.getTargetException();
            }
            throw ite;
        }
    }

    private Method getDelegateMethod(Method method) throws NoSuchMethodException {
        return this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
    }

    private Map<String, Serializable> getCacheIndexes(Method method, Object[] args) {
        HashMap<String, Serializable> invalidateIndexes = new HashMap<String, Serializable>();
        for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
            Annotation[] annotationsForParameter;
            for (Annotation a : annotationsForParameter = method.getParameterAnnotations()[i]) {
                if (!a.annotationType().equals(CacheIndex.class)) continue;
                CacheIndex cacheIndex = (CacheIndex)a;
                invalidateIndexes.put(cacheIndex.key(), this.getArgValue(args[i], cacheIndex.property()));
            }
        }
        return invalidateIndexes;
    }

    private Serializable getArgValue(Object object, String property) {
        if (object == null) {
            return null;
        }
        if ("".equals(property)) {
            return (Serializable)object;
        }
        try {
            return (Serializable)propertyUtils.getNestedProperty(object, property);
        }
        catch (Exception e) {
            logger.warn("Failed to extract argValue for " + object + "." + property, (Throwable)e);
            return null;
        }
    }

    public Object getDelegate() {
        return this.delegate;
    }
}

