package no.tornado.inject;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>A beanProviderMethod annotated with @Destroy("methodName") will ensure that the destroy
 * method is called when the ApplicationContext shuts down. The ApplicationContext either shuts
 * down when you call the ApplicationContext.shutdown() method, or when the JVM exits.</p>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Destroy {
    String value();
}
