package no.tornado.inject;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>Annotate any beanProviderMethod with @Intercept("interceptorBean") to
 * reference another bean that must implement the MethodInterceptor interface.</p>
 *
 * <p>The MethodInterceptor#intercept() method will be called so you can intercept
 * all method calls in the proxied bean and even alter the returned object. This is
 * where you would add automatic transaction handling etc.</p>
 *
 * @see MethodInterceptor
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Intercept {
    String value();
}
