package no.tornado.inject.module;

import java.util.ArrayList;
import java.util.List;

public class MessageBus {
    private static List<InjectEventListener> listeners = new ArrayList<>();

    public static void publish(InjectEvent event) {
        for (InjectEventListener listener : listeners.toArray(new InjectEventListener[listeners.size()])) {
            try {
                listener.onEvent(event);
            } catch (Exception ignored) {

            }
        }
    }

    public static void subscribe(InjectEventListener listener) {
        listeners.add(listener);
    }

    public static void unsubscribe(InjectEventListener listener) {
        listeners.remove(listener);
    }

}
