package no.tornado.inject.module;

import java.net.URL;
import java.net.URLClassLoader;

public class ModuleClassLoader extends URLClassLoader {
    private Module module;

    public ModuleClassLoader(Module module, URL[] classPathEntries) {
        super(classPathEntries, ModuleSystem.getRootClassLoader());
        this.module = module;
    }

    /**
     * Load class from this module, if the package is marked as exported
     * @param name The name of the class
     * @return The class
     * @throws ClassNotFoundException if class is not found
     */
    public Class<?> loadExportedClass(String name) throws ClassNotFoundException {
        Class<?> clazz = findLoadedClass(name);
        if (clazz == null)
            clazz = findClass(name);

        if (module.getExportPackages().contains(clazz.getPackage().getName()))
            return clazz;

        throw new ClassNotFoundException();
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            // Make sure that the Inject, except for the module system is loaded in each module's classloader
            if (name.startsWith("no.tornado.inject.") && !name.startsWith("no.tornado.inject.module.")) {
                Class clazz = findLoadedClass(name);
                if (clazz != null)
                    return clazz;

                return findClass(name);
            }

            return super.loadClass(name, resolve);
        } catch (ClassNotFoundException tryOtherModules) {
            return ModuleSystem.loadExportedClass(module, name);
        }
    }

    public Module getModule() {
        return this.module;
    }
}
