package no.tornado.inject.module;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ModuleClassLoaderFactory {
    private List<URL> classPathEntries = new ArrayList<>();
    private Module module;

    public ModuleClassLoaderFactory(Module module, List<URL> classPathEntries) {
        this.module = module;
        this.classPathEntries = classPathEntries;
    }

    public ModuleClassLoader createClassLoader() {
        return new ModuleClassLoader(module, classPathEntries.toArray(new URL[classPathEntries.size()]));
    }

    public List<URL> getClassPathEntries() {
        return classPathEntries;
    }

    public void setClassPathEntries(List<URL> classPathEntries) {
        this.classPathEntries = classPathEntries;
    }

    public Module getModule() {
        return module;
    }

    public void setModule(Module module) {
        this.module = module;
    }
}
