package no.tornado.inject.module;

public class ServiceAvailabilityEvent implements InjectEvent {
    public enum EVENT_TYPE { SERVICE_ADDED, SERVICE_REMOVED };
    private final ServiceRouter router;
    private final EVENT_TYPE eventType;

    public ServiceAvailabilityEvent(ServiceRouter router, EVENT_TYPE eventType) {
        if (router == null || eventType == null)
            throw new IllegalArgumentException("All fields in " + getClass() + " must be populated!");

        this.eventType = eventType;
        this.router = router;
    }

    public String toString() {
        return eventType + ": " + router;
    }

    public ServiceRouter getRouter() {
        return router;
    }

    public EVENT_TYPE getEventType() {
        return eventType;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ServiceAvailabilityEvent that = (ServiceAvailabilityEvent) o;

        return router.equals(that.router) && eventType == that.eventType;
    }

    public int hashCode() {
        int result = router.hashCode();
        result = 31 * result + eventType.hashCode();
        return result;
    }
}
