package no.tornado.inject.module;

public class ServiceRouter {
    private final String serviceClass;
    private final Integer serviceHash;
    private Object bean;
    private String options;

    public ServiceRouter(String serviceClass, Integer serviceHash, Object bean, String options) {
        if (serviceClass == null || serviceHash == null || bean == null || options == null)
            throw new IllegalArgumentException("All fields in " + getClass() + " must be populated!");

        this.serviceClass = serviceClass;
        this.serviceHash = serviceHash;
        this.bean = bean;
        this.options = options;
    }

    public String toString() {
        return serviceClass + " (" + serviceHash + ")";
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ServiceRouter that = (ServiceRouter) o;

        if (!serviceClass.equals(that.serviceClass)) return false;
        if (!serviceHash.equals(that.serviceHash)) return false;

        return true;
    }

    public int hashCode() {
        int result = serviceClass.hashCode();
        result = 31 * result + serviceHash.hashCode();
        return result;
    }

    public String getServiceClass() {
        return serviceClass;
    }

    public Integer getServiceHash() {
        return serviceHash;
    }

    public Object getBean() {
        return bean;
    }

    public String getOptions() {
        return options;
    }
}
