package no.tornado.inject.servlet;

import no.tornado.inject.ApplicationContext;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import java.io.IOException;

/**
 * Subclasses of this servlet will automatically support @Inject and @Require annotations and
 * thereby support dependency injection for servlets.
 *
 * When running under Tomcat, register InjectWrapper instead so you don't need to extend InjectServlet
 *
 * @see no.tornado.inject.servlet.tomcat.InjectWrapper
 */
public class InjectServlet extends HttpServlet {

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        ApplicationContext.inject(this);
        super.service(req, res);
    }
}
