package no.tornado.inject.servlet.tomcat;

import no.tornado.inject.ApplicationContext;
import org.apache.catalina.core.StandardWrapper;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import java.lang.reflect.Method;

/**
 * <p>When registered in a Tomcat Context as the wrapperClass it will
 * automatically support @Inject and @Require annotations in your servlets
 * without requiring you to extend InjectServlet.</p>
 *
 * <p>Usage in <strong>META-INF/context.xml</strong>:</p>
 *
 * <pre>
 *     &lt;Context wrapperClass="no.tornado.inject.servlet.tomcat.InjectWrapper"&gt;
 *     ...
 *     &lt;/Context&gt;
 * </pre>
 *
 * <p><strong>IMPORTANT:</strong> You need to put inject.jar in tomcat/lib for this to work</p>
 */
public class InjectWrapper extends StandardWrapper {
    @SuppressWarnings("unchecked")
    public synchronized Servlet loadServlet() throws ServletException {
        Servlet servlet = super.loadServlet();
        if (servlet != null) {
            try {
                Class acc = servlet.getClass().getClassLoader().loadClass(ApplicationContext.class.getName());
                Method injectMethod = acc.getMethod("inject", new Class[]{Object.class});
                injectMethod.invoke(null, servlet);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return servlet;
    }
}
