/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import no.tornado.inject.BeanCreationException;
import no.tornado.inject.BeanInfo;
import no.tornado.inject.BeanNameAware;
import no.tornado.inject.BeanProxy;
import no.tornado.inject.CacheStore;
import no.tornado.inject.Destroy;
import no.tornado.inject.Ignore;
import no.tornado.inject.InitializingBean;
import no.tornado.inject.Inject;
import no.tornado.inject.module.MessageBus;
import no.tornado.inject.module.ModuleSystem;
import no.tornado.inject.module.Provides;
import no.tornado.inject.module.Require;
import no.tornado.inject.module.ServiceProxy;
import no.tornado.inject.module.ServiceRouter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationContext {
    private static Log logger = LogFactory.getLog(ApplicationContext.class);
    private static Thread shutdownHook;
    private static Map<String, BeanInfo> beansByName;
    private static Map<Class, List<BeanInfo>> beansByClass;
    private static Timer cacheInvalidationTimer;
    private static final int DEFAULT_SERVICE_TIMEOUT = 10;

    public static void registerBeans(Object beanProvider) {
        if (!ModuleSystem.isActive() && shutdownHook == null) {
            ApplicationContext.installShutdownHook();
        }
        Long before = new Date().getTime();
        Boolean cachesCreated = false;
        for (Method beanCreationMethod : ApplicationContext.getMethodsRecursive(beanProvider.getClass())) {
            if (beanCreationMethod.getAnnotation(Ignore.class) != null) {
                logger.debug((Object)("Ignoring bean " + beanCreationMethod.getName()));
                continue;
            }
            logger.info((Object)("Registering bean " + beanCreationMethod.getName()));
            BeanInfo beanInfo = new BeanInfo(beanCreationMethod, beanProvider);
            if (CacheStore.class.equals(beanCreationMethod.getReturnType())) {
                cachesCreated = true;
            }
            beansByName.put(beanInfo.getBeanName(), beanInfo);
            List<BeanInfo> beansBySameClass = beansByClass.get(beanInfo.getBeanCreationMethod().getReturnType());
            if (beansBySameClass == null) {
                beansBySameClass = new ArrayList<BeanInfo>();
                beansByClass.put(beanInfo.getBeanCreationMethod().getReturnType(), beansBySameClass);
            }
            beansBySameClass.add(beanInfo);
        }
        for (BeanInfo beanInfo : beansByName.values()) {
            Provides provides;
            if (beanInfo.isEager()) {
                beanInfo.getBean();
            }
            if ((provides = beanInfo.getBeanCreationMethod().getAnnotation(Provides.class)) == null) continue;
            String serviceName = provides.service() == Provides.RETURNED_CLASS.class ? beanInfo.getBeanCreationMethod().getReturnType().getName() : provides.service().getName();
            ServiceRouter router = new ServiceRouter(serviceName, beanInfo.getServiceHash(), beanInfo.getBean(), provides.options());
            ModuleSystem.addServiceRouter(router);
        }
        if (cachesCreated.booleanValue() && cacheInvalidationTimer == null) {
            ApplicationContext.createCacheInvalidationTimer();
        }
        logger.info((Object)("Registered beans from " + beanProvider + " in " + (new Date().getTime() - before) + " ms"));
    }

    public static void installShutdownHook() {
        shutdownHook = new AppContextShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private static void createCacheInvalidationTimer() {
        cacheInvalidationTimer = new Timer("CacheInvalidationTimer", true);
        cacheInvalidationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                List<CacheStore> cacheStores = ApplicationContext.getBeans(CacheStore.class);
                for (CacheStore cacheStore : cacheStores) {
                    cacheStore.invalidateExpired();
                }
            }
        }, 60000L, 60000L);
    }

    public static Object getBean(String beanName) {
        BeanInfo beanInfo = ApplicationContext.getBeanInfo(beanName);
        return beanInfo == null ? null : beanInfo.getBean();
    }

    public static <T> T getBean(Class<T> className) {
        List<BeanInfo> thisClassInfos = ApplicationContext.getBeanInfos(className);
        return (T)(thisClassInfos.isEmpty() ? null : ApplicationContext.getBeanInfos(className).get(0).getBean());
    }

    public static BeanInfo getBeanInfo(String beanName) {
        return beansByName.get(beanName);
    }

    public static <T> List<T> getBeans(Class<T> className) {
        ArrayList<Object> beans = new ArrayList<Object>();
        List<BeanInfo> beansByThisClass = beansByClass.get(className);
        if (beansByThisClass == null) {
            return new ArrayList();
        }
        for (BeanInfo beanInfo : beansByThisClass) {
            beans.add(beanInfo.getBean());
        }
        return beans;
    }

    public static List<BeanInfo> getBeanInfos(Class className) {
        return beansByClass.get(className);
    }

    public static void inject(final Object object) {
        BeanInfo mockBeanInfo = new BeanInfo(){

            @Override
            public String getBeanName() {
                return object.getClass().getName();
            }
        };
        ApplicationContext.injectMembers(mockBeanInfo, object);
    }

    static void postProcessBean(BeanInfo beanInfo, Object bean) {
        ApplicationContext.injectMembers(beanInfo, bean);
        if (bean instanceof BeanNameAware) {
            logger.debug((Object)("Setting beanName for " + beanInfo.getBeanName()));
            ((BeanNameAware)bean).setBeanName(beanInfo.getBeanName());
        }
        if (bean instanceof InitializingBean) {
            logger.debug((Object)("Calling afterPropertiesSet for " + beanInfo.getBeanName()));
            ((InitializingBean)bean).afterPropertiesSet();
        }
    }

    private static void injectMembers(BeanInfo beanInfo, Object bean) {
        logger.debug((Object)("Injecting members into " + beanInfo.getBeanName()));
        for (Field field : ApplicationContext.getFieldsRecursive(bean.getClass())) {
            Require require;
            Inject inject = field.getAnnotation(Inject.class);
            if (inject != null) {
                field.setAccessible(true);
                if (inject.bean().equals("")) {
                    logger.debug((Object)("Injecting " + beanInfo.getBeanName() + "." + field.getName() + " by className"));
                    List<?> beansByClassName = ApplicationContext.getBeans(field.getType());
                    if (beansByClassName.isEmpty()) {
                        throw new BeanCreationException("Unable to inject " + beanInfo.getBeanName() + "." + field.getName() + ": No bean with type " + field.getType().getName() + " found in ApplicationContext", beanInfo);
                    }
                    try {
                        field.set(bean, beansByClassName.get(0));
                    }
                    catch (IllegalAccessException e) {
                        throw new BeanCreationException("Unable to inject " + beanInfo.getBeanName() + "." + field.getName(), beanInfo, e);
                    }
                }
                logger.debug((Object)("Injecting " + beanInfo.getBeanName() + "." + field.getName() + " by beanName"));
                Object beanToInject = ApplicationContext.getBean(inject.bean());
                if (beanToInject == null) {
                    throw new BeanCreationException("Unable to inject " + beanInfo.getBeanName() + "." + field.getName() + ": No bean with name " + inject.bean() + " found in ApplicationContext", beanInfo);
                }
                try {
                    field.set(bean, beanToInject);
                }
                catch (IllegalAccessException e) {
                    throw new BeanCreationException("Unable to inject " + beanInfo.getBeanName() + "." + field.getName(), beanInfo, e);
                }
            }
            if ((require = field.getAnnotation(Require.class)) == null) continue;
            field.setAccessible(true);
            logger.debug((Object)("Injecting service proxy into " + beanInfo.getBeanName() + "." + field.getName()));
            try {
                Class serviceClass = require.service() == Provides.RETURNED_CLASS.class ? field.getType() : require.service();
                field.set(bean, ApplicationContext.getService(serviceClass, require.timeout(), require.options()));
            }
            catch (IllegalAccessException e) {
                throw new BeanCreationException("Unable to inject service proxy " + beanInfo.getBeanName() + "." + field.getName(), beanInfo, e);
            }
        }
    }

    public static <T> T getService(Class<T> serviceClass) {
        return ApplicationContext.getService(serviceClass, 10, "");
    }

    public static <T> T getService(Class<T> serviceClass, int timeout) {
        return ApplicationContext.getService(serviceClass, timeout, "");
    }

    public static <T> T getService(Class<T> serviceClass, int timeout, String options) {
        ServiceProxy serviceProxy = new ServiceProxy(serviceClass.getName(), timeout, options);
        MessageBus.subscribe(serviceProxy);
        return (T)Proxy.newProxyInstance(serviceClass.getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)serviceProxy);
    }

    public static void shutdown() {
        new AppContextShutdownHook().run();
    }

    private static List<Field> getFieldsRecursive(Class beanClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ApplicationContext.addFieldsRecursive(fields, beanClass);
        return fields;
    }

    private static void addFieldsRecursive(List<Field> fields, Class beanClass) {
        fields.addAll(Arrays.asList(beanClass.getDeclaredFields()));
        if (beanClass.getSuperclass() != null) {
            ApplicationContext.addFieldsRecursive(fields, beanClass.getSuperclass());
        }
    }

    private static List<Method> getMethodsRecursive(Class beanClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ApplicationContext.addMethodsRecursive(methods, beanClass);
        return methods;
    }

    private static void addMethodsRecursive(List<Method> methods, Class beanClass) {
        methods.addAll(Arrays.asList(beanClass.getDeclaredMethods()));
        if (beanClass.getSuperclass() != null && !beanClass.getSuperclass().equals(Object.class)) {
            ApplicationContext.addMethodsRecursive(methods, beanClass.getSuperclass());
        }
    }

    private static List<Object> getBeanProviders() {
        ArrayList<Object> beanProviders = new ArrayList<Object>();
        for (BeanInfo info : beansByName.values()) {
            if (beanProviders.contains(info.getProvider())) continue;
            beanProviders.add(info.getProvider());
        }
        return beanProviders;
    }

    static {
        beansByName = new HashMap<String, BeanInfo>();
        beansByClass = new HashMap<Class, List<BeanInfo>>();
        Class<Destroy> clazz = Destroy.class;
    }

    private static class AppContextShutdownHook
    extends Thread {
        private AppContextShutdownHook() {
        }

        @Override
        public void run() {
            for (Object beanProvider : ApplicationContext.getBeanProviders()) {
                for (Method beanCreationMethod : beanProvider.getClass().getDeclaredMethods()) {
                    Provides provides;
                    BeanInfo beanInfo = null;
                    Destroy destroy = beanCreationMethod.getAnnotation(Destroy.class);
                    if (destroy != null) {
                        beanInfo = ApplicationContext.getBeanInfo(beanCreationMethod.getName());
                        if (!beanInfo.isInstatiated().booleanValue()) {
                            logger.info((Object)("Skipping destroy method for non-instantiated bean " + beanInfo.getBeanName() + "#" + destroy.value() + "()"));
                            continue;
                        }
                        Object bean = beanInfo.getBean();
                        if (Proxy.isProxyClass(bean.getClass())) {
                            BeanProxy lazyLoader = (BeanProxy)Proxy.getInvocationHandler(bean);
                            Object delegate = lazyLoader.getDelegate();
                            if (delegate != null) {
                                logger.info((Object)("Running destroy method " + delegate.getClass().getName() + " " + beanInfo.getBeanName() + "#" + destroy.value() + "()"));
                                try {
                                    delegate.getClass().getMethod(destroy.value(), new Class[0]).invoke(delegate, new Object[0]);
                                }
                                catch (Exception ignored) {}
                            }
                        } else {
                            try {
                                logger.info((Object)("Running destroy method " + bean.getClass().getName() + "#" + destroy.value() + "()"));
                                bean.getClass().getMethod(destroy.value(), new Class[0]).invoke(bean, new Object[0]);
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                    }
                    if ((provides = beanCreationMethod.getAnnotation(Provides.class)) == null) continue;
                    if (beanInfo == null) {
                        beanInfo = ApplicationContext.getBeanInfo(beanCreationMethod.getName());
                    }
                    ModuleSystem.removeServiceRouter(beanInfo.getBeanCreationMethod().getReturnType().getName(), beanInfo.getServiceHash());
                }
            }
            beansByName.clear();
            beansByClass.clear();
        }
    }
}

