/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import no.tornado.inject.BeanNameAware;
import no.tornado.inject.CacheInterceptor;
import no.tornado.inject.CacheKeyGenerator;
import no.tornado.inject.DefaultCacheKeyGenerator;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheStore
implements Serializable,
BeanNameAware {
    private static Log logger = LogFactory.getLog(CacheStore.class);
    public static final Integer DEFAULT_CACHE_MINUTES = 60;
    public static final Integer DEFAULT_MAX_OBJECTS = 8192;
    private String beanName;
    private Integer cacheMinutes = DEFAULT_CACHE_MINUTES;
    private Integer maxObjects = DEFAULT_MAX_OBJECTS;
    private CacheKeyGenerator keyGenerator;
    private CacheInterceptor cacheInterceptor;
    private Map<String, Map<Serializable, Map<String, Void>>> indexes;
    private Map<String, CacheEntry> store;

    public CacheStore() {
        this(DEFAULT_MAX_OBJECTS);
    }

    public CacheStore(Integer maxObjects) {
        this.store = Collections.synchronizedMap(new IndexedLRUMap(maxObjects));
        this.indexes = new HashMap<String, Map<Serializable, Map<String, Void>>>();
        this.keyGenerator = new DefaultCacheKeyGenerator();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.beanName + "\n");
        s.append("Cache timeout: " + this.cacheMinutes + " minutes\n");
        s.append("Max objects: " + this.maxObjects + "\n");
        s.append("Current objects: " + this.store.size() + "\n");
        s.append("Current size: " + this.calculateObjectSize() + " bytes\n");
        s.append("Registered indexes: " + this.indexes.keySet());
        return s.toString();
    }

    private long calculateObjectSize() {
        long size = 0L;
        for (CacheEntry entry : this.store.values()) {
            if (entry.data == null) continue;
            size += (long)entry.data.length;
        }
        return size;
    }

    public void store(String cacheKey, Serializable object, Map<String, Serializable> indexEntries, Long expires) throws IOException {
        CacheEntry cacheEntry = new CacheEntry();
        cacheEntry.setKey(cacheKey);
        cacheEntry.setIndexEntries(indexEntries);
        cacheEntry.setCachedObject(object);
        cacheEntry.setExpires(expires);
        this.store.put(cacheKey, cacheEntry);
        for (Map.Entry<String, Serializable> indexEntry : indexEntries.entrySet()) {
            Map<String, Void> valuesForThisIndex;
            Map<Serializable, Map<String, Void>> keysForThisIndex = this.indexes.get(indexEntry.getKey());
            if (keysForThisIndex == null) {
                keysForThisIndex = new HashMap<Serializable, Map<String, Void>>();
                this.indexes.put(indexEntry.getKey(), keysForThisIndex);
            }
            if ((valuesForThisIndex = keysForThisIndex.get(indexEntry.getValue())) == null) {
                valuesForThisIndex = new HashMap<String, Void>();
                keysForThisIndex.put(indexEntry.getValue(), valuesForThisIndex);
            }
            valuesForThisIndex.put(cacheKey, null);
        }
    }

    public Object lookup(String key) throws ClassNotFoundException, IOException {
        CacheEntry entry = this.store.get(key);
        if (entry != null) {
            logger.debug((Object)(this.beanName + " hit: " + key));
            return entry.getCachedObject();
        }
        logger.debug((Object)(this.beanName + " miss: " + key));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidate(Map<String, Serializable> invalidateIndexes) {
        if (invalidateIndexes.isEmpty()) {
            logger.debug((Object)("Invalidating " + this.beanName));
            Map<String, CacheEntry> map = this.store;
            synchronized (map) {
                this.store.clear();
                this.indexes.clear();
                return true;
            }
        }
        logger.debug((Object)("Invalidating " + this.beanName + " entries with indexes " + invalidateIndexes));
        for (Map.Entry<String, Serializable> indexEntry : invalidateIndexes.entrySet()) {
            Map<Serializable, Map<String, Void>> keysForThisIndex = this.indexes.get(indexEntry.getKey());
            if (keysForThisIndex == null) continue;
            Map<String, Void> valuesForThisIndex = keysForThisIndex.get(indexEntry.getValue());
            if (valuesForThisIndex != null) {
                for (String cacheKey : valuesForThisIndex.keySet()) {
                    this.invalidate(cacheKey);
                }
            }
            return true;
        }
        return false;
    }

    public void flush() {
        this.store.clear();
    }

    private void invalidate(String cacheKey) {
        CacheEntry cacheEntry = this.store.remove(cacheKey);
        if (cacheEntry != null) {
            logger.debug((Object)("Invalidating " + this.beanName + " cache key " + cacheKey));
            this.invalidateIndexes(cacheKey, cacheEntry);
        } else {
            logger.debug((Object)("Tried to invalidate non-existent " + this.beanName + " cache key " + cacheKey));
        }
    }

    private void invalidateIndexes(String cacheKey, CacheEntry cacheEntry) {
        Set<Map.Entry<String, Serializable>> indexSet = cacheEntry.getIndexEntries().entrySet();
        for (Map.Entry<String, Serializable> indexEntry : indexSet) {
            Map<Serializable, Map<String, Void>> indexesForKey = this.indexes.get(indexEntry.getKey());
            if (indexesForKey == null) continue;
            indexesForKey.remove(indexEntry.getValue());
            logger.debug((Object)("Removed index " + indexEntry.getKey() + "=" + indexEntry.getValue() + " for cache key " + cacheKey));
        }
    }

    public Integer getCacheMinutes() {
        return this.cacheMinutes;
    }

    public void setCacheMinutes(Integer cacheMinutes) {
        this.cacheMinutes = cacheMinutes;
    }

    public Integer getMaxObjects() {
        return this.maxObjects;
    }

    public void setMaxObjects(Integer maxObjects) {
        this.maxObjects = maxObjects;
    }

    public CacheKeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(CacheKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public CacheInterceptor getCacheInterceptor() {
        return this.cacheInterceptor;
    }

    public void setCacheInterceptor(CacheInterceptor cacheInterceptor) {
        this.cacheInterceptor = cacheInterceptor;
    }

    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void invalidateExpired() {
        ArrayList<String> expiredKeys = new ArrayList<String>();
        Long now = new Date().getTime();
        for (CacheEntry entry : this.store.values()) {
            if (now - entry.getTouched() > (long)(this.cacheMinutes * 60000)) {
                expiredKeys.add(entry.getKey());
                continue;
            }
            if (entry.getExpires() == null || entry.expires <= now) continue;
            expiredKeys.add(entry.getKey());
        }
        for (String key : expiredKeys) {
            this.invalidate(key);
        }
    }

    private class IndexedLRUMap
    extends LRUMap {
        public IndexedLRUMap(Integer maxObjects) {
            super(maxObjects.intValue());
        }

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            CacheStore.this.invalidateIndexes((String)entry.getKey(), (CacheEntry)entry.getValue());
            return true;
        }
    }

    private class CacheEntry
    implements Serializable {
        private String key;
        private Map<String, Serializable> indexEntries = new HashMap<String, Serializable>();
        private byte[] data;
        private Long touched;
        private Long expires;

        private CacheEntry() {
        }

        public String toString() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheEntry that = (CacheEntry)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Map<String, Serializable> getIndexEntries() {
            return this.indexEntries;
        }

        public void setIndexEntries(Map<String, Serializable> indexEntries) {
            this.indexEntries = indexEntries;
        }

        public void setCachedObject(Object cachedObject) throws IOException {
            this.touched = new Date().getTime();
            if (cachedObject == null) {
                this.data = null;
            } else {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                     ObjectOutputStream out = new ObjectOutputStream(baos);){
                    out.writeObject(cachedObject);
                    this.data = baos.toByteArray();
                }
            }
        }

        /*
         * Exception decompiling
         */
        public Object getCachedObject() throws IOException, ClassNotFoundException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Long getTouched() {
            return this.touched;
        }

        public Long getExpires() {
            return this.expires;
        }

        public void setExpires(Long expires) {
            this.expires = expires;
        }
    }
}

