/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject.module;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import no.tornado.inject.ApplicationContext;
import no.tornado.inject.module.ModuleClassLoader;
import no.tornado.inject.module.ModuleClassLoaderFactory;
import no.tornado.inject.module.ModuleSystem;

public class Module {
    public static final String MODULE_NAME = "Module-Name";
    public static final String MODULE_DESCRIPTION = "Module-Description";
    public static final String MODULE_CONTEXT = "Module-Context";
    public static final String MODULE_VERSION = "Module-Version";
    public static final String EXPORT_PACKAGE = "Export-Package";
    public static final String EXPORT_PACKAGE_DELIMITER = "\\s*,\\s*";
    private Integer id;
    private String name;
    private String description;
    private String contextClass;
    private Object _context;
    private String version;
    private List<String> exportPackages;
    private ModuleClassLoader _classLoader;
    private ModuleClassLoaderFactory classLoaderFactory;
    private STATE state = STATE.INSTALLED;
    private CLASSLOADER_STATE classloaderState = CLASSLOADER_STATE.OK;
    private File jarFile;
    private Date startTime;

    public Module() {
    }

    public Module(String name, String description, String contextClass, String version, List<String> exportPackages, ModuleClassLoaderFactory classLoaderFactory) {
        this.name = name;
        this.description = description;
        this.contextClass = contextClass;
        this.version = version;
        this.exportPackages = exportPackages;
        this.classLoaderFactory = classLoaderFactory;
    }

    public String toString() {
        return this.name + " (" + this.description + ")" + " version " + this.version;
    }

    public STATE getState() {
        return this.state;
    }

    public void setState(STATE state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        if (this.jarFile != null ? !this.jarFile.equals(module.jarFile) : module.jarFile != null) {
            return false;
        }
        if (!this.name.equals(module.name)) {
            return false;
        }
        return this.version.equals(module.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.jarFile != null ? this.jarFile.hashCode() : 0);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getExportPackages() {
        return this.exportPackages;
    }

    public void setExportPackages(List<String> exportPackages) {
        this.exportPackages = exportPackages;
    }

    public ModuleClassLoader getClassLoader() {
        if (this._classLoader == null) {
            this._classLoader = this.classLoaderFactory.createClassLoader();
        }
        return this._classLoader;
    }

    public void stop() throws Exception {
        if (this.state == STATE.RUNNING || this.state == STATE.STARTING) {
            this.state = STATE.STOPPING;
            try {
                this.invokeOnApplicationContext("shutdown", new Object[0]);
                this.invalidateClassLoader();
                ModuleSystem.signoff(this);
            }
            finally {
                this.state = STATE.INSTALLED;
                this.startTime = null;
            }
        }
    }

    public void invalidateClassLoader() {
        this._classLoader = null;
        this._context = null;
    }

    public boolean start() throws Exception {
        if (this.state != STATE.RUNNING && this.state != STATE.STARTING) {
            this.state = STATE.STOPPING;
            try {
                if (this.getContext() != null) {
                    this.invokeOnApplicationContext("registerBeans", this.getContext());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.state = STATE.RUNNING;
                this.classloaderState = CLASSLOADER_STATE.OK;
                this.startTime = new Date();
            }
        }
        return false;
    }

    public String getUpTime() {
        if (this.startTime == null) {
            return "DOWN";
        }
        long uptime = (new Date().getTime() - this.startTime.getTime()) / 1000L;
        int days = (int)uptime / 86400;
        String retval = "";
        if (days != 0) {
            retval = retval + days + " " + (days > 1 ? "days" : "day") + ", ";
        }
        int minutes = (int)uptime / 60;
        int hours = minutes / 60;
        retval = (hours %= 24) != 0 ? retval + hours + ":" + minutes : (minutes != 0 ? retval + (minutes %= 60) + " min" : retval + uptime + " sec");
        return retval;
    }

    public static String formatUptime(double uptime) {
        String retval = "";
        int days = (int)uptime / 86400;
        if (days != 0) {
            retval = retval + days + " " + (days > 1 ? "days" : "day") + ", ";
        }
        int minutes = (int)uptime / 60;
        int hours = minutes / 60;
        retval = (hours %= 24) != 0 ? retval + hours + ":" + minutes : retval + (minutes %= 60) + " min";
        return retval;
    }

    private Object getContext() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this._context != null) {
            return this._context;
        }
        if (this.contextClass != null) {
            try {
                this._context = this.getClassLoader().loadClass(this.contextClass).newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Module '" + this.getName() + "' defined context class " + this.contextClass + ", but it was not found in the module classpath");
            }
            return this._context;
        }
        return null;
    }

    public Object invokeOnApplicationContext(String methodName, Object ... args) throws Exception {
        try {
            Method method;
            Class<?> appContextClass = this.getClassLoader().loadClass(ApplicationContext.class.getName());
            if (args == null || args.length == 0) {
                method = appContextClass.getDeclaredMethod(methodName, new Class[0]);
            } else {
                Class[] parameterTypes = new Class[args.length];
                if (methodName.equals("registerBeans")) {
                    parameterTypes[0] = Object.class;
                } else {
                    for (int i = 0; i < args.length; ++i) {
                        Object arg = args[i];
                        parameterTypes[i] = arg == null ? Object.class : arg.getClass();
                    }
                }
                method = appContextClass.getDeclaredMethod(methodName, parameterTypes);
            }
            if (method == null) {
                throw new IllegalArgumentException("Tried to execute non-existent method on ApplicationContext.class: " + methodName + ". Check args/type!");
            }
            return method.invoke(null, args);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof Exception) {
                throw (Exception)ex.getCause();
            }
            ex.getCause().printStackTrace();
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    public CLASSLOADER_STATE getClassloaderState() {
        return this.classloaderState;
    }

    public void setClassloaderState(CLASSLOADER_STATE classloaderState) {
        this.classloaderState = classloaderState;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ModuleClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public void setClassLoaderFactory(ModuleClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public static enum CLASSLOADER_STATE {
        OK,
        DIRTY;

    }

    public static enum STATE {
        INSTALLED,
        STARTING,
        RUNNING,
        STOPPING;

    }
}

