/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject.module;

import java.net.URL;
import java.net.URLClassLoader;
import no.tornado.inject.module.Module;
import no.tornado.inject.module.ModuleSystem;

public class ModuleClassLoader
extends URLClassLoader {
    private Module module;

    public ModuleClassLoader(Module module, URL[] classPathEntries) {
        super(classPathEntries, ModuleSystem.getRootClassLoader());
        this.module = module;
    }

    public Class<?> loadExportedClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.findClass(name);
        }
        if (this.module.getExportPackages().contains(clazz.getPackage().getName())) {
            return clazz;
        }
        throw new ClassNotFoundException();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            if (name.startsWith("no.tornado.inject.") && !name.startsWith("no.tornado.inject.module.")) {
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
                return this.findClass(name);
            }
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException tryOtherModules) {
            return ModuleSystem.loadExportedClass(this.module, name);
        }
    }

    public Module getModule() {
        return this.module;
    }
}

