/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject.module;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import no.tornado.inject.Inject;
import no.tornado.inject.module.InjectEvent;
import no.tornado.inject.module.InjectEventListener;
import no.tornado.inject.module.MessageBus;
import no.tornado.inject.module.Module;
import no.tornado.inject.module.ModuleClassLoaderFactory;
import no.tornado.inject.module.ServiceAvailabilityEvent;
import no.tornado.inject.module.ServiceRouter;
import no.tornado.inject.webconsole.WebConsole;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class ModuleSystem {
    private static Log logger = LogFactory.getLog(ModuleSystem.class);
    private static Map<Integer, Module> modules = new HashMap<Integer, Module>();
    private static Map<String, Integer> moduleNameMap = new HashMap<String, Integer>();
    private static Map<String, List<Integer>> exportedPackages = new HashMap<String, List<Integer>>();
    private static Map<Integer, List<Integer>> exportedClassesUsage = new HashMap<Integer, List<Integer>>();
    private static ModuleSystem INSTANCE;
    private static Map<String, List<ServiceRouter>> serviceProviders;
    private static File moduleFolder;
    private static Module.STATE defaultState;
    private static Integer moduleSequence;
    private static ClassLoader rootClassLoader;
    private static boolean disabled;

    private ModuleSystem() {
    }

    public static List<String> getExportedPackages() {
        Set<String> strings = exportedPackages.keySet();
        return Arrays.asList(strings.toArray(new String[strings.size()]));
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            ModuleSystem.setModuleFolder(new File(args[0]));
        } else {
            ModuleSystem.setModuleFolder(new File("modules"));
        }
        if (args.length > 2) {
            WebConsole.create().basicAuth(args[1], args[2]).start();
        }
        ModuleSystem.init();
        System.in.read();
    }

    public static void init() {
        if (!ModuleSystem.isActive()) {
            INSTANCE = new ModuleSystem();
            logger.info((Object)"Tornado Inject Module System is active");
            if (moduleFolder != null) {
                ModuleSystem.installModules();
            }
        }
    }

    public static void installModules() {
        if (moduleFolder.isFile()) {
            logger.error((Object)("Module folder " + moduleFolder + " is pointing to a file, , autoloading of modules is disabled."));
            return;
        }
        if (!moduleFolder.exists() && !moduleFolder.mkdirs()) {
            logger.error((Object)"Unable to create module folder, autoloading of modules is disabled.");
            return;
        }
        logger.info((Object)("Installing not currently installed modules from " + moduleFolder.getAbsolutePath() + "..."));
        if (moduleFolder.exists()) {
            for (File moduleJar : moduleFolder.listFiles(new JarFilter())) {
                if (ModuleSystem.isAlreadyRegistered(moduleJar)) {
                    logger.debug((Object)("Module jar " + moduleJar + " already registered, skipping installation."));
                    continue;
                }
                try {
                    logger.info((Object)("Installing module " + moduleJar));
                    ModuleSystem.install(moduleJar.getAbsolutePath());
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to install module " + moduleJar + ": " + e.getMessage()));
                }
            }
            for (File mavenModuleCandidate : moduleFolder.listFiles(new FolderFilter())) {
                File pom = new File(mavenModuleCandidate, "pom.xml");
                if (!pom.exists()) continue;
                try {
                    Module module = ModuleSystem.createFromPom(pom);
                    if (ModuleSystem.isAlreadyRegistered(module)) {
                        logger.debug((Object)("Maven Module " + module + " already registered, skipping installation."));
                        continue;
                    }
                    try {
                        logger.info((Object)("Installing maven module " + module));
                        ModuleSystem.install(module);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to install maven module " + module + ": " + e.getMessage()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (defaultState == Module.STATE.RUNNING) {
                for (Module module : modules.values()) {
                    try {
                        logger.info((Object)("Starting module " + module.toString()));
                        module.start();
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to start module " + module + ": " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static boolean isAlreadyRegistered(File moduleJar) {
        try {
            for (Module module : modules.values()) {
                if (module.getJarFile() == null || !moduleJar.getCanonicalPath().equals(module.getJarFile().getCanonicalPath())) continue;
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public static boolean isAlreadyRegistered(Module checkModule) {
        for (Module module : modules.values()) {
            if (!module.equals(checkModule)) continue;
            return true;
        }
        return false;
    }

    public static boolean start(Integer moduleId) throws Exception {
        return ModuleSystem.getModule(moduleId).start();
    }

    public static boolean start(String jarFile) throws Exception {
        return ModuleSystem.install(jarFile).start();
    }

    public static void stop(Integer moduleId) throws Exception {
        ModuleSystem.getModule(moduleId).stop();
    }

    public static void restart(Integer moduleId) throws Exception {
        Module module = ModuleSystem.getModule(moduleId);
        module.stop();
        module.start();
    }

    public static void uninstall(Integer moduleId) throws Exception {
        ModuleSystem.stop(moduleId);
        ModuleSystem.removeExportedPackages(moduleId);
        Module module = modules.remove(moduleId);
        if (module != null) {
            moduleNameMap.remove(module.getName());
        }
    }

    public static Collection<Module> list() {
        return modules.values();
    }

    public static Module install(Module module) {
        ModuleSystem.init();
        Integer moduleId = ModuleSystem.getNextModuleId();
        modules.put(moduleId, module);
        module.setId(moduleId);
        moduleNameMap.put(module.getName(), moduleId);
        ModuleSystem.updateExportedPackages(moduleId);
        return module;
    }

    private static Integer getNextModuleId() {
        moduleSequence = moduleSequence + 1;
        return moduleSequence;
    }

    public static Module install(String jarFile) throws Exception {
        String exportPackage;
        File file = new File(jarFile);
        if (file.getName().equals("pom.xml")) {
            return ModuleSystem.install(ModuleSystem.createFromPom(file));
        }
        JarFile jar = new JarFile(file);
        Manifest manifest = jar.getManifest();
        Attributes attr = manifest.getMainAttributes();
        Module module = new Module();
        module.setJarFile(file);
        module.setName(attr.getValue("Module-Name"));
        if (module.getName() == null) {
            module.setName(file.getName());
        }
        module.setDescription(attr.getValue("Module-Description"));
        module.setVersion(attr.getValue("Module-Version"));
        if (module.getVersion() == null) {
            module.setVersion("SNAPSHOT");
        }
        ArrayList<URL> classPathEntries = new ArrayList<URL>();
        classPathEntries.add(file.toURI().toURL());
        ModuleSystem.addTornadoInject(classPathEntries);
        module.setClassLoaderFactory(new ModuleClassLoaderFactory(module, classPathEntries));
        String contextClass = attr.getValue("Module-Context");
        if (contextClass != null) {
            module.setContextClass(contextClass);
        }
        if ((exportPackage = attr.getValue("Export-Package")) != null) {
            ArrayList<String> exportPackages = new ArrayList<String>();
            exportPackages.addAll(Arrays.asList(exportPackage.split("\\s*,\\s*")));
            module.setExportPackages(exportPackages);
        }
        return ModuleSystem.install(module);
    }

    public static Module createFromPom(File pom) throws Exception {
        String moduleContext;
        XPath x = XPathFactory.newInstance().newXPath();
        DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Module module = new Module();
        module.setName(pom.getParentFile().getName());
        Document doc = b.parse(pom);
        String exportPackage = x.evaluate("//manifestEntries/Export-Package", doc).trim();
        if (exportPackage != null) {
            module.setExportPackages(new ArrayList<String>());
            module.getExportPackages().addAll(Arrays.asList(exportPackage.split("\\s*,\\s*")));
        }
        if (!"".equals(moduleContext = x.evaluate("//manifestEntries/Module-Context", doc))) {
            module.setContextClass(moduleContext);
        }
        module.setVersion(x.evaluate("//project/version", doc));
        if (module.getVersion() == null) {
            module.setVersion("SNAPSHOT");
        }
        module.setDescription("Auto-created from " + pom.getAbsolutePath());
        ArrayList<URL> classPathEntries = new ArrayList<URL>();
        classPathEntries.add(new File(pom.getParentFile(), "target/classes").toURI().toURL());
        ModuleSystem.addTornadoInject(classPathEntries);
        module.setClassLoaderFactory(new ModuleClassLoaderFactory(module, classPathEntries));
        return module;
    }

    private static void addTornadoInject(List<URL> classPathEntries) {
        String injectPackagePath = Inject.class.getPackage().getName().replace(".", "/");
        ClassLoader cl = ModuleSystem.getRootClassLoader();
        if (cl == null) {
            throw new RuntimeException("Neither configured rootClassLoader or System Classloader can be retrieved.");
        }
        URL injectPackageUrl = cl.getResource(injectPackagePath);
        if (injectPackageUrl == null) {
            throw new RuntimeException("Could not find Tornado Inject in System Classloader or configured rootClassLoader!");
        }
        try {
            classPathEntries.add(new URL(injectPackageUrl.toString().replaceAll(injectPackagePath + "$", "")));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Unable to create URL from Tornado Inject classpath entries!");
        }
    }

    private static void updateExportedPackages(Integer moduleId) {
        Module module = modules.get(moduleId);
        if (module.getExportPackages() != null) {
            for (String packageName : module.getExportPackages()) {
                if ("".equals(packageName.replaceAll(" ", ""))) continue;
                List<Integer> modulesProvidingPackage = exportedPackages.get(packageName);
                if (modulesProvidingPackage == null) {
                    modulesProvidingPackage = new ArrayList<Integer>();
                    exportedPackages.put(packageName, modulesProvidingPackage);
                }
                modulesProvidingPackage.add(moduleId);
            }
        }
    }

    private static void removeExportedPackages(Integer moduleId) {
        Module module = modules.get(moduleId);
        if (module.getExportPackages() != null) {
            for (String packageName : module.getExportPackages()) {
                List<Integer> modulesProvidingPackage = exportedPackages.get(packageName);
                if (modulesProvidingPackage == null) continue;
                modulesProvidingPackage.remove(moduleId);
            }
        }
    }

    public static Class<?> loadExportedClass(Module caller, String name) throws ClassNotFoundException {
        if (!name.contains(".")) {
            throw new ClassNotFoundException("Unable to load exported class without package name: " + name);
        }
        String packageName = name.substring(0, name.lastIndexOf("."));
        List<Integer> modulesProvidingPackage = exportedPackages.get(packageName);
        if (modulesProvidingPackage != null && !modulesProvidingPackage.isEmpty()) {
            Integer providingModuleId = modulesProvidingPackage.get(0);
            Class<?> clazz = modules.get(providingModuleId).getClassLoader().loadExportedClass(name);
            ModuleSystem.recordExportedClassUsage(caller, providingModuleId);
            return clazz;
        }
        throw new ClassNotFoundException("Unable to load class " + name + ", it was not exported from any modules.");
    }

    private static void recordExportedClassUsage(Module caller, Integer providingModuleId) {
        List<Integer> clients = exportedClassesUsage.get(providingModuleId);
        if (clients == null) {
            clients = new ArrayList<Integer>();
            exportedClassesUsage.put(providingModuleId, clients);
        }
        if (caller != null && !clients.contains(caller.getId())) {
            clients.add(caller.getId());
        }
    }

    public static Module getModule(Integer moduleId) {
        return modules.get(moduleId);
    }

    public static Module getModule(String name) {
        Integer moduleId = moduleNameMap.get(name);
        return moduleId != null ? modules.get(moduleId) : null;
    }

    public static boolean isDisabled() {
        return disabled;
    }

    public static void disable() {
        disabled = true;
    }

    public static void disable(boolean disable) {
        disabled = disable;
    }

    public static boolean isActive() {
        return INSTANCE != null;
    }

    public static void addServiceRouter(ServiceRouter router) {
        logger.debug((Object)("Adding ServiceRouter " + router));
        List<ServiceRouter> servicesForClass = serviceProviders.get(router.getServiceClass());
        if (servicesForClass == null) {
            servicesForClass = new ArrayList<ServiceRouter>();
            serviceProviders.put(router.getServiceClass(), servicesForClass);
        }
        servicesForClass.add(router);
        MessageBus.publish(new ServiceAvailabilityEvent(router, ServiceAvailabilityEvent.EVENT_TYPE.SERVICE_ADDED));
    }

    public static void shutdown() throws Exception {
        logger.debug((Object)"Shutting down module system");
        for (Module module : ModuleSystem.list().toArray(new Module[0])) {
            ModuleSystem.uninstall(module.getId());
        }
        INSTANCE = null;
    }

    public static void removeServiceRouter(String serviceName, int serviceHash) {
        List<ServiceRouter> routers = serviceProviders.get(serviceName);
        if (routers != null) {
            ListIterator<ServiceRouter> li = routers.listIterator();
            while (li.hasNext()) {
                ServiceRouter router = li.next();
                if (!router.getServiceHash().equals(serviceHash)) continue;
                logger.debug((Object)("Unregistering ServiceRouter " + router));
                li.remove();
                MessageBus.publish(new ServiceAvailabilityEvent(router, ServiceAvailabilityEvent.EVENT_TYPE.SERVICE_REMOVED));
            }
        }
    }

    public static List<ServiceRouter> getServiceRouters(String serviceClass, String options) {
        List<ServiceRouter> routersForClass = serviceProviders.get(serviceClass);
        ArrayList<ServiceRouter> matchingOptions = new ArrayList<ServiceRouter>();
        if (routersForClass == null) {
            return Collections.emptyList();
        }
        for (ServiceRouter router : routersForClass) {
            if (!router.getOptions().equals(options)) continue;
            matchingOptions.add(router);
        }
        return matchingOptions;
    }

    public static void setDefaultState(Module.STATE defaultState) {
        ModuleSystem.defaultState = defaultState;
    }

    public static File getModuleFolder() {
        return moduleFolder;
    }

    public static void signoff(Module module) {
        List<Integer> clientModules = exportedClassesUsage.get(module.getId());
        if (clientModules != null) {
            for (Integer moduleId : clientModules) {
                Module client = ModuleSystem.getModule(moduleId);
                if (client == null) continue;
                client.setClassloaderState(Module.CLASSLOADER_STATE.DIRTY);
            }
        }
        exportedClassesUsage.remove(module.getId());
    }

    public static void setModuleFolder(File moduleFolder) {
        ModuleSystem.moduleFolder = moduleFolder;
    }

    public static void setRootClassLoader(ClassLoader rootClassLoader) {
        ModuleSystem.rootClassLoader = rootClassLoader;
    }

    public static ClassLoader getRootClassLoader() {
        return rootClassLoader;
    }

    public static void runWhenAvailable(Class serviceClass, Runnable work) {
        ModuleSystem.runWhenAvailable(serviceClass.getName(), "", work);
    }

    public static void runWhenAvailable(final String serviceClass, final String options, final Runnable work) {
        if (options == null) {
            throw new IllegalArgumentException("Options must be not null, or Provides.NO_OPTIONS");
        }
        List<ServiceRouter> routers = ModuleSystem.getServiceRouters(serviceClass, options);
        if (!routers.isEmpty()) {
            new Thread(work).start();
        } else {
            InjectEventListener listener = new InjectEventListener(){

                @Override
                public void onEvent(InjectEvent event) {
                    ServiceAvailabilityEvent e;
                    if (event instanceof ServiceAvailabilityEvent && (e = (ServiceAvailabilityEvent)event).getEventType().equals((Object)ServiceAvailabilityEvent.EVENT_TYPE.SERVICE_ADDED) && e.getRouter().getServiceClass().equals(serviceClass) && e.getRouter().getOptions().equals(options)) {
                        new Thread(work).start();
                        MessageBus.unsubscribe(this);
                    }
                }
            };
            MessageBus.subscribe(listener);
        }
    }

    static {
        serviceProviders = new HashMap<String, List<ServiceRouter>>();
        defaultState = Module.STATE.RUNNING;
        moduleSequence = 0;
        rootClassLoader = ClassLoader.getSystemClassLoader();
        disabled = false;
    }

    private static class JarFilter
    implements FilenameFilter {
        private JarFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    }

    public static class FolderFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

