/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject.module;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import no.tornado.inject.module.InjectEvent;
import no.tornado.inject.module.InjectEventListener;
import no.tornado.inject.module.ModuleSystem;
import no.tornado.inject.module.ServiceAvailabilityEvent;
import no.tornado.inject.module.ServiceNotAvailableException;
import no.tornado.inject.module.ServiceRouter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceProxy
implements InvocationHandler,
InjectEventListener {
    private static Log logger = LogFactory.getLog(ServiceProxy.class);
    private final String serviceClass;
    private final int timeout;
    private ServiceRouter router;
    private String options;

    public ServiceProxy(String serviceClass, int timeout, String options) {
        this.serviceClass = serviceClass;
        this.timeout = timeout;
        this.options = options;
        List<ServiceRouter> routers = ModuleSystem.getServiceRouters(serviceClass, options);
        this.router = routers.isEmpty() ? null : routers.get(routers.size() - 1);
    }

    public String toString() {
        return "ServiceProxy " + this.serviceClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.router == null) {
            this.waitOrDie();
        }
        try {
            Object bean = this.router.getBean();
            Method beanMethod = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
            return beanMethod.invoke(bean, args);
        }
        catch (UndeclaredThrowableException ex) {
            throw ex.getCause();
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() != null) {
                if (ite.getTargetException() instanceof UndeclaredThrowableException) {
                    throw ite.getTargetException().getCause();
                }
                throw ite.getTargetException();
            }
            throw ite;
        }
    }

    private void waitOrDie() {
        int i = 0;
        while (this.router == null && i < this.timeout) {
            ++i;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.router == null) {
            throw new ServiceNotAvailableException(this.serviceClass);
        }
    }

    @Override
    public void onEvent(InjectEvent event) {
        if (event instanceof ServiceAvailabilityEvent) {
            ServiceAvailabilityEvent sea = (ServiceAvailabilityEvent)event;
            if (ServiceAvailabilityEvent.EVENT_TYPE.SERVICE_REMOVED == sea.getEventType() && this.router.equals(sea.getRouter())) {
                logger.debug((Object)("Removing " + this.router + " from ServiceProxy " + this));
                this.router = null;
            }
            if (ServiceAvailabilityEvent.EVENT_TYPE.SERVICE_ADDED == sea.getEventType() && sea.getRouter().getServiceClass().equals(this.serviceClass) && sea.getRouter().getOptions().equals(this.options)) {
                logger.debug((Object)("Adding " + sea.getRouter() + " to ServiceProxy " + this + ", previous router was " + this.router));
                this.router = sea.getRouter();
            }
        }
    }
}

