/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import no.tornado.inject.module.ModuleSystem;

@WebListener
public class ModuleSystemServletListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        if (ModuleSystem.isDisabled() || "true".equals(sce.getServletContext().getInitParameter("disable-tornado-modulesystem")) || ModuleSystem.isActive()) {
            return;
        }
        File moduleFolder = null;
        String configuredModuleFolder = sce.getServletContext().getInitParameter("injectModuleFolder");
        if (configuredModuleFolder != null) {
            moduleFolder = new File(configuredModuleFolder);
        } else {
            String devPomPath = sce.getServletContext().getRealPath("../../../pom.xml");
            if (devPomPath != null) {
                File developmentPom = new File(devPomPath);
                if (developmentPom.exists()) {
                    try {
                        moduleFolder = developmentPom.getParentFile().getCanonicalFile();
                    }
                    catch (IOException e) {
                        moduleFolder = developmentPom.getParentFile();
                    }
                } else {
                    moduleFolder = new File(sce.getServletContext().getRealPath("WEB-INF/modules"));
                }
            }
        }
        if (moduleFolder != null && moduleFolder.exists()) {
            ModuleSystem.setRootClassLoader(this.getClass().getClassLoader());
            ModuleSystem.setModuleFolder(moduleFolder);
            ModuleSystem.init();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (ModuleSystem.isActive()) {
            try {
                ModuleSystem.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

