/*
 * Decompiled with CFR 0.152.
 */
package no.tornado.inject;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import no.tornado.inject.ApplicationContext;
import no.tornado.inject.BeanInfo;
import no.tornado.inject.Intercept;
import no.tornado.inject.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProxy
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(BeanProxy.class);
    private BeanInfo beanInfo;
    private Object delegate;
    private Interceptor interceptor;

    public BeanProxy(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.delegate == null) {
            logger.info("Lazily instatiating bean " + this.beanInfo.getBeanName());
            this.delegate = this.beanInfo.instantiate();
            Intercept intercept = this.beanInfo.getBeanCreationMethod().getAnnotation(Intercept.class);
            if (intercept != null) {
                this.interceptor = (Interceptor)ApplicationContext.getBean(intercept.value());
            }
        }
        if (this.interceptor != null) {
            return this.interceptor.intercept(this.delegate, this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes()), args);
        }
        return this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(this.delegate, args);
    }

    public Object getDelegate() {
        return this.delegate;
    }
}

