/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import tornadofx.App;
import tornadofx.EmptyResourceBundle;
import tornadofx.FX;
import tornadofx.FXResourceBundleControl;
import tornadofx.Injectable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltornadofx/FX;", "", "()V", "Companion", "tornadofx"})
public final class FX {
    private static final Logger log;
    @NotNull
    public static Stage primaryStage;
    @NotNull
    public static App application;
    private static final ObservableList<String> stylesheets;
    @NotNull
    private static final HashMap<KClass<? extends Injectable>, Injectable> components;
    @NotNull
    private static final Object lock;
    private static final SimpleObjectProperty<Locale> _locale;
    private static final SimpleObjectProperty<ResourceBundle> _messages;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        log = Logger.getLogger("FX");
        stylesheets = FXCollections.observableArrayList();
        components = new HashMap();
        lock = new Object();
        _locale = (SimpleObjectProperty)new SimpleObjectProperty<Locale>(){

            protected void invalidated() {
                tornadofx.FX$Companion.access$loadMessages(FX.Companion);
            }
        };
        _messages = new SimpleObjectProperty();
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Companion.setLocale(locale);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u00105\u001a\u000206H\u0002J\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\f\u00108\u001a\b\u0012\u0004\u0012\u00020\t0\u0004J\u0014\u00109\u001a\u0002062\f\u0010:\u001a\b\u0012\u0004\u0012\u0002060;R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R%\u0010\u0011\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010 \u001a\n \"*\u0004\u0018\u00010!0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R$\u0010%\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R5\u00100\u001a&\u0012\f\u0012\n \"*\u0004\u0018\u00010202 \"*\u0012\u0012\f\u0012\n \"*\u0004\u0018\u00010202\u0018\u00010101\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006<"}, d2={"Ltornadofx/FX$Companion;", "", "()V", "_locale", "Ljavafx/beans/property/SimpleObjectProperty;", "Ljava/util/Locale;", "get_locale", "()Ljavafx/beans/property/SimpleObjectProperty;", "_messages", "Ljava/util/ResourceBundle;", "get_messages", "application", "Ltornadofx/App;", "getApplication", "()Ltornadofx/App;", "setApplication", "(Ltornadofx/App;)V", "components", "Ljava/util/HashMap;", "Lkotlin/reflect/KClass;", "Ltornadofx/Injectable;", "getComponents", "()Ljava/util/HashMap;", "value", "locale", "getLocale", "()Ljava/util/Locale;", "setLocale", "(Ljava/util/Locale;)V", "lock", "getLock", "()Ljava/lang/Object;", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "messages", "getMessages", "()Ljava/util/ResourceBundle;", "setMessages", "(Ljava/util/ResourceBundle;)V", "primaryStage", "Ljavafx/stage/Stage;", "getPrimaryStage", "()Ljavafx/stage/Stage;", "setPrimaryStage", "(Ljavafx/stage/Stage;)V", "stylesheets", "Ljavafx/collections/ObservableList;", "", "getStylesheets", "()Ljavafx/collections/ObservableList;", "loadMessages", "", "localeProperty", "messagesProperty", "runAndWait", "action", "Lkotlin/Function0;", "tornadofx"})
    public static final class Companion {
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final Stage getPrimaryStage() {
            Stage stage = primaryStage;
            if (stage == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"primaryStage");
            }
            return stage;
        }

        public final void setPrimaryStage(@NotNull Stage stage) {
            Intrinsics.checkParameterIsNotNull((Object)stage, (String)"<set-?>");
            primaryStage = stage;
        }

        @NotNull
        public final App getApplication() {
            App app = application;
            if (app == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"application");
            }
            return app;
        }

        public final void setApplication(@NotNull App app) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"<set-?>");
            application = app;
        }

        public final ObservableList<String> getStylesheets() {
            return stylesheets;
        }

        @NotNull
        public final HashMap<KClass<? extends Injectable>, Injectable> getComponents() {
            return components;
        }

        @NotNull
        public final Object getLock() {
            return lock;
        }

        private final SimpleObjectProperty<Locale> get_locale() {
            return _locale;
        }

        @NotNull
        public final Locale getLocale() {
            Locale locale = (Locale)Companion.get_locale().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"_locale.get()");
            return locale;
        }

        public final void setLocale(@NotNull Locale value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Companion.get_locale().set((Object)value);
        }

        @NotNull
        public final SimpleObjectProperty<Locale> localeProperty() {
            return this.get_locale();
        }

        private final SimpleObjectProperty<ResourceBundle> get_messages() {
            return _messages;
        }

        @NotNull
        public final ResourceBundle getMessages() {
            ResourceBundle resourceBundle = (ResourceBundle)Companion.get_messages().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceBundle, (String)"_messages.get()");
            return resourceBundle;
        }

        public final void setMessages(@NotNull ResourceBundle value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Companion.get_messages().set((Object)value);
        }

        @NotNull
        public final SimpleObjectProperty<ResourceBundle> messagesProperty() {
            return this.get_messages();
        }

        private final void loadMessages() {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("Messages", this.getLocale(), FXResourceBundleControl.Companion.getINSTANCE());
                Intrinsics.checkExpressionValueIsNotNull((Object)resourceBundle, (String)"ResourceBundle.getBundle\u2026ceBundleControl.INSTANCE)");
                this.setMessages(resourceBundle);
            }
            catch (Exception ex) {
                this.getLog().fine(loadMessages.1.INSTANCE);
                this.setMessages(EmptyResourceBundle.Companion.getINSTANCE());
            }
        }

        public final void runAndWait(@NotNull Function0<Unit> action) {
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            if (Platform.isFxApplicationThread()) {
                action.invoke();
                return;
            }
            CountDownLatch doneLatch = new CountDownLatch(1);
            Platform.runLater((Runnable)new Runnable(action, doneLatch){
                final /* synthetic */ Function0 $action;
                final /* synthetic */ CountDownLatch $doneLatch;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        this.$action.invoke();
                    }
                    finally {
                        this.$doneLatch.countDown();
                    }
                }
                {
                    this.$action = function0;
                    this.$doneLatch = countDownLatch;
                }
            });
            try {
                doneLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ void access$loadMessages(Companion $this) {
            $this.loadMessages();
        }
    }
}

