/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.HttpClientEngine;
import tornadofx.HttpClientResponse;
import tornadofx.JsonModel;
import tornadofx.Rest;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Ltornadofx/HttpClientRequest;", "Ltornadofx/Rest$Request;", "engine", "Ltornadofx/HttpClientEngine;", "client", "Lorg/apache/http/impl/client/CloseableHttpClient;", "seq", "", "method", "Ltornadofx/Rest$Request$Method;", "uri", "Ljava/net/URI;", "entity", "", "(Ltornadofx/HttpClientEngine;Lorg/apache/http/impl/client/CloseableHttpClient;JLtornadofx/Rest$Request$Method;Ljava/net/URI;Ljava/lang/Object;)V", "getClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "getEngine", "()Ltornadofx/HttpClientEngine;", "getEntity", "()Ljava/lang/Object;", "getMethod", "()Ltornadofx/Rest$Request$Method;", "request", "Lorg/apache/http/client/methods/HttpRequestBase;", "getRequest", "()Lorg/apache/http/client/methods/HttpRequestBase;", "getSeq", "()J", "getUri", "()Ljava/net/URI;", "addHeader", "", "name", "", "value", "execute", "Ltornadofx/Rest$Response;", "tornadofx"})
public final class HttpClientRequest
implements Rest.Request {
    @NotNull
    private final HttpRequestBase request;
    @NotNull
    private final HttpClientEngine engine;
    @NotNull
    private final CloseableHttpClient client;
    private final long seq;
    @NotNull
    private final Rest.Request.Method method;
    @NotNull
    private final URI uri;
    @Nullable
    private final Object entity;

    @NotNull
    public final HttpRequestBase getRequest() {
        return this.request;
    }

    @Override
    @NotNull
    public Rest.Response execute() {
        CloseableHttpResponse httpResponse;
        Function1<Rest.Request, Unit> function1 = this.engine.getAuthInterceptor();
        Unit unit = function1 != null ? (Unit)function1.invoke((Object)this) : null;
        if (this.getEntity() != null && this.request instanceof HttpEntityEnclosingRequestBase) {
            Object object;
            if (!this.request.containsHeader("Content-Type")) {
                this.addHeader("Content-Type", "application/json");
            }
            if ((object = this.getEntity()) instanceof JsonModel) {
                ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)new StringEntity(((JsonModel)this.getEntity()).toJSON().toString(), StandardCharsets.UTF_8));
            } else if (object instanceof JsonValue) {
                ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)new StringEntity(this.getEntity().toString(), StandardCharsets.UTF_8));
            } else if (object instanceof InputStream) {
                ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)new InputStreamEntity((InputStream)this.getEntity()));
            } else {
                throw (Throwable)new IllegalArgumentException("Don't know how to handle entity of type " + this.getEntity().getClass());
            }
        }
        CloseableHttpResponse closeableHttpResponse = httpResponse = this.client.execute((HttpUriRequest)this.request, (HttpContext)this.engine.getContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"httpResponse");
        HttpClientResponse response = new HttpClientResponse(this, closeableHttpResponse);
        Function1<Rest.Response, Unit> function12 = this.engine.getResponseInterceptor();
        Unit unit2 = function12 != null ? (Unit)function12.invoke((Object)response) : null;
        return response;
    }

    @Override
    public void addHeader(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.request.addHeader(name, value);
    }

    @NotNull
    public final HttpClientEngine getEngine() {
        return this.engine;
    }

    @NotNull
    public final CloseableHttpClient getClient() {
        return this.client;
    }

    @Override
    public long getSeq() {
        return this.seq;
    }

    @Override
    @NotNull
    public Rest.Request.Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public URI getUri() {
        return this.uri;
    }

    @Override
    @Nullable
    public Object getEntity() {
        return this.entity;
    }

    public HttpClientRequest(@NotNull HttpClientEngine engine, @NotNull CloseableHttpClient client, long seq, @NotNull Rest.Request.Method method, @NotNull URI uri, @Nullable Object entity) {
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.engine = engine;
        this.client = client;
        this.seq = seq;
        this.method = method;
        this.uri = uri;
        this.entity = entity;
        Rest.Request.Method method2 = this.getMethod();
        if (Intrinsics.areEqual((Object)((Object)method2), (Object)((Object)Rest.Request.Method.GET))) {
            this.request = (HttpRequestBase)new HttpGet(this.getUri());
        } else if (Intrinsics.areEqual((Object)((Object)method2), (Object)((Object)Rest.Request.Method.PUT))) {
            this.request = (HttpRequestBase)new HttpPut(this.getUri());
        } else if (Intrinsics.areEqual((Object)((Object)method2), (Object)((Object)Rest.Request.Method.POST))) {
            this.request = (HttpRequestBase)new HttpPost(this.getUri());
        } else if (Intrinsics.areEqual((Object)((Object)method2), (Object)((Object)Rest.Request.Method.DELETE))) {
            this.request = (HttpRequestBase)new HttpDelete(this.getUri());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

