/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javafx.application.Platform;
import javax.json.JsonArray;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import tornadofx.HttpClientRequest;
import tornadofx.Rest;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\u0010\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Ltornadofx/HttpClientResponse;", "Ltornadofx/Rest$Response;", "request", "Ltornadofx/HttpClientRequest;", "response", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "(Ltornadofx/HttpClientRequest;Lorg/apache/http/client/methods/CloseableHttpResponse;)V", "reason", "", "getReason", "()Ljava/lang/String;", "getRequest", "()Ltornadofx/HttpClientRequest;", "getResponse", "()Lorg/apache/http/client/methods/CloseableHttpResponse;", "statusCode", "", "getStatusCode", "()I", "bytes", "", "consume", "content", "Ljava/io/InputStream;", "kotlin.jvm.PlatformType", "text", "tornadofx"})
public final class HttpClientResponse
implements Rest.Response {
    @NotNull
    private final HttpClientRequest request;
    @NotNull
    private final CloseableHttpResponse response;

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    @NotNull
    public String getReason() {
        String string = this.response.getStatusLine().getReasonPhrase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.statusLine.reasonPhrase");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String text() {
        try {
            String string = EntityUtils.toString((HttpEntity)this.response.getEntity(), (Charset)StandardCharsets.UTF_8);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EntityUtils.toString(response.entity, UTF_8)");
            String string2 = string;
            return string2;
        }
        finally {
            this.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Rest.Response consume() {
        Rest.Response response;
        EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        try {
            if (this.response instanceof CloseableHttpResponse) {
                this.response.close();
            }
            response = this;
        }
        catch (Throwable throwable) {
            Platform.runLater((Runnable)new Runnable(this){
                final /* synthetic */ HttpClientResponse this$0;

                public final void run() {
                    Rest.Companion.getOngoingRequests().remove((Object)this.this$0.getRequest());
                }
                {
                    this.this$0 = httpClientResponse;
                }
            });
            throw throwable;
        }
        Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
        return response;
    }

    @Override
    public InputStream content() {
        return this.response.getEntity().getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] bytes() {
        try {
            byte[] byArray = EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"EntityUtils.toByteArray(response.entity)");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            this.consume();
        }
    }

    @Override
    @NotNull
    public HttpClientRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final CloseableHttpResponse getResponse() {
        return this.response;
    }

    public HttpClientResponse(@NotNull HttpClientRequest request, @NotNull CloseableHttpResponse response) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.request = request;
        this.response = response;
    }

    @Override
    @NotNull
    public JsonArray list() {
        return Rest.Response.DefaultImpls.list(this);
    }

    @Override
    @NotNull
    public JsonObject one() {
        return Rest.Response.DefaultImpls.one(this);
    }

    @Override
    public boolean ok() {
        return Rest.Response.DefaultImpls.ok(this);
    }
}

