package tornadofx

import javafx.scene.layout.VBox

class SwitchApp : App() {
    override val primaryView = FirstView::class
}


class FirstView: View() {
    override val root = VBox()
    val secondView : SecondView by inject()

    init {
        title = "First view"

        with(root) {
            label(title)
            button("Switch to Second View") {
                setOnAction {
                    replaceWith(secondView, ViewTransition.SlideIn)
                }
            }
        }
    }
}

class SecondView: View() {
    override val root = VBox()
    val firstView : FirstView by inject()

    init {
        title = "Second view"

        with(root) {
            label(title)
            button("Switch to First View") {
                setOnAction {
                    switchToFirst()
                }
            }
        }
    }

    private fun switchToFirst() {
        replaceWith(firstView, ViewTransition.SlideOut)
    }
}

