/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tornadofx.ErrorHandlerKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Ltornadofx/DefaultErrorHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "uncaughtException", "", "t", "Ljava/lang/Thread;", "error", "", "tornadofx"})
public final class DefaultErrorHandler
implements Thread.UncaughtExceptionHandler {
    private final Logger log = Logger.getLogger("ErrorHandler");

    public final Logger getLog() {
        return this.log;
    }

    @Override
    public void uncaughtException(@NotNull Thread t2, @NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)t2, (String)"t");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this.log.log(Level.SEVERE, "Uncaught error", error);
        Platform.runLater((Runnable)new Runnable(error){
            final /* synthetic */ Throwable $error;

            public final void run() {
                String string;
                if (this.$error.getCause() != null) {
                    Throwable throwable = this.$error.getCause();
                    string = throwable != null ? throwable.getMessage() : null;
                } else {
                    string = "";
                }
                Label label2 = new Label(string);
                Label $receiver = label2;
                $receiver.setStyle("-fx-font-weight: bold");
                Label cause = label2;
                TextArea textArea = new TextArea();
                TextArea $receiver2 = textArea;
                $receiver2.setPrefRowCount(20);
                $receiver2.setPrefColumnCount(50);
                $receiver2.setText(ErrorHandlerKt.access$stringFromError(this.$error));
                TextArea textarea = textArea;
                textArea = new Alert(Alert.AlertType.ERROR);
                $receiver2 = (Alert)textArea;
                String string2 = this.$error.getMessage();
                if (string2 == null) {
                    string2 = "An error occured";
                }
                $receiver2.setTitle(string2);
                $receiver2.setResizable(true);
                $receiver2.setHeaderText("Error in " + ExceptionsKt.getStackTrace((Throwable)this.$error)[0].toString());
                $receiver2.getDialogPane().setContent((Node)new VBox(new Node[]{(Node)cause, (Node)textarea}));
                $receiver2.showAndWait();
            }
            {
                this.$error = throwable;
            }
        });
    }
}

