/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.Arrays;
import java.util.Map;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.Component;
import tornadofx.FX;
import tornadofx.FXKt;
import tornadofx.NodesKt;
import tornadofx.Stylesheet;
import tornadofx.View;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bBG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0005\u0012\"\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00050\b\"\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\nB=\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0005\u0012\"\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00050\b\"\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0003J%\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00140\u0013\"\u000e\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0015*\u00020\u0016H\u0087\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Ltornadofx/App;", "Ljavafx/application/Application;", "icon", "Ljavafx/scene/image/Image;", "primaryView", "Lkotlin/reflect/KClass;", "Ltornadofx/View;", "stylesheet", "", "Ltornadofx/Stylesheet;", "(Ljavafx/scene/image/Image;Lkotlin/reflect/KClass;[Lkotlin/reflect/KClass;)V", "(Lkotlin/reflect/KClass;[Lkotlin/reflect/KClass;)V", "getPrimaryView", "()Lkotlin/reflect/KClass;", "createPrimaryScene", "Ljavafx/scene/Scene;", "view", "determinePrimaryView", "inject", "Lkotlin/properties/ReadOnlyProperty;", "T", "Ltornadofx/Component;", "Ltornadofx/Injectable;", "start", "", "stage", "Ljavafx/stage/Stage;", "DeterminedByParameter", "tornadofx"})
public class App
extends Application {
    @NotNull
    private final KClass<? extends View> primaryView;

    @NotNull
    public KClass<? extends View> getPrimaryView() {
        return this.primaryView;
    }

    public void start(@NotNull Stage stage) {
        Intrinsics.checkParameterIsNotNull((Object)stage, (String)"stage");
        FX.Companion.registerApplication(this, stage);
        try {
            View view = FXKt.find(this.determinePrimaryView());
            Stage stage2 = stage;
            Stage $receiver = stage2;
            $receiver.setScene(this.createPrimaryScene(view));
            Map map = (Map)view.getProperties();
            String string = "tornadofx.scene";
            Scene scene = $receiver.getScene();
            map.put(string, scene);
            Scene scene2 = $receiver.getScene();
            Intrinsics.checkExpressionValueIsNotNull((Object)scene2, (String)"scene");
            FX.Companion.applyStylesheetsTo(scene2);
            $receiver.titleProperty().bind((ObservableValue)view.getTitleProperty());
            NodesKt.hookGlobalShortcuts($receiver);
            $receiver.show();
            FX.Companion.getInitialized().setValue(Boolean.valueOf(true));
        }
        catch (Exception ex) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), ex);
        }
    }

    @NotNull
    public Scene createPrimaryScene(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return new Scene(view.getRoot());
    }

    private final KClass<? extends View> determinePrimaryView() {
        if (Intrinsics.areEqual(this.getPrimaryView(), (Object)Reflection.getOrCreateKotlinClass(DeterminedByParameter.class))) {
            Object object = this.getParameters().getNamed();
            if (object == null || (object = (String)object.get("view-class")) == null) {
                throw (Throwable)new IllegalArgumentException("No provided --view-class parameter and primaryView was not overridden. Choose one strategy to specify the primary View");
            }
            Object viewClassName = object;
            Class<?> viewClass = Class.forName((String)viewClassName);
            if (View.class.isAssignableFrom(viewClass)) {
                KClass kClass = JvmClassMappingKt.getKotlinClass(viewClass);
                if (kClass == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<out tornadofx.View>");
                }
                return kClass;
            }
            throw (Throwable)new IllegalArgumentException("Class specified by --class-name is not a subclass of tornadofx.View");
        }
        return this.getPrimaryView();
    }

    private final <T extends Component> ReadOnlyProperty<App, T> inject() {
        Intrinsics.needClassReification();
        return new ReadOnlyProperty<App, T>(){

            @NotNull
            public T getValue(@NotNull App thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)thisRef), (String)"thisRef");
                Intrinsics.checkParameterIsNotNull(property, (String)"property");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return FXKt.find(Reflection.getOrCreateKotlinClass(Component.class));
            }
        };
    }

    public App(@Nullable KClass<? extends View> primaryView, KClass<? extends Stylesheet> ... stylesheet) {
        Intrinsics.checkParameterIsNotNull(stylesheet, (String)"stylesheet");
        KClass kClass = primaryView;
        if (kClass == null) {
            kClass = Reflection.getOrCreateKotlinClass(DeterminedByParameter.class);
        }
        this.primaryView = kClass;
        Object[] $receiver$iv = stylesheet;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            KClass it = (KClass)element$iv;
            FXKt.importStylesheet(it);
        }
    }

    public /* synthetic */ App(KClass kClass, KClass[] kClassArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kClass = null;
        }
        this((KClass<? extends View>)kClass, kClassArray);
    }

    public App(@NotNull Image icon, @Nullable KClass<? extends View> primaryView, KClass<? extends Stylesheet> ... stylesheet) {
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        Intrinsics.checkParameterIsNotNull(stylesheet, (String)"stylesheet");
        this(primaryView, Arrays.copyOf(stylesheet, stylesheet.length));
        FXKt.addStageIcon(icon);
    }

    public /* synthetic */ App(Image image, KClass kClass, KClass[] kClassArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kClass = null;
        }
        this(image, (KClass<? extends View>)kClass, kClassArray);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ltornadofx/App$DeterminedByParameter;", "Ltornadofx/View;", "()V", "root", "Ljavafx/scene/layout/Pane;", "getRoot", "()Ljavafx/scene/layout/Pane;", "tornadofx"})
    public static final class DeterminedByParameter
    extends View {
        @NotNull
        private final Pane root = new Pane();

        @NotNull
        public Pane getRoot() {
            return this.root;
        }

        public DeterminedByParameter() {
            super(null, 1, null);
        }
    }
}

