/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.DataGrid;
import tornadofx.DataGridCell;
import tornadofx.DataGridRow;
import tornadofx.DataGridSkin;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\nJ,\u0010\u0014\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tH\u0016J,\u0010\u0015\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\t0\tH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0015\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\u001c\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\n\u0010\u001f\u001a\u00020 \"\u00020\nH\u0016J\b\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020\u000eH\u0016J\b\u0010#\u001a\u00020\u000eH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R2\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ltornadofx/DataGridSelectionModel;", "T", "Ljavafx/scene/control/MultipleSelectionModel;", "dataGrid", "Ltornadofx/DataGrid;", "(Ltornadofx/DataGrid;)V", "getDataGrid", "()Ltornadofx/DataGrid;", "selectedIndicies", "Ljavafx/collections/ObservableList;", "", "kotlin.jvm.PlatformType", "selectedItems", "clearAndSelect", "", "index", "clearSelection", "clearSelectionAndReapply", "getCellAt", "Ltornadofx/DataGridCell;", "getSelectedIndices", "getSelectedItems", "isEmpty", "", "isSelected", "select", "obj", "(Ljava/lang/Object;)V", "selectAll", "selectFirst", "selectIndices", "indices", "", "selectLast", "selectNext", "selectPrevious", "tornadofx"})
public final class DataGridSelectionModel<T>
extends MultipleSelectionModel<T> {
    private final ObservableList<Integer> selectedIndicies;
    private final ObservableList<T> selectedItems;
    @NotNull
    private final DataGrid<T> dataGrid;

    @Nullable
    public final DataGridCell<T> getCellAt(int index) {
        Skin skin = this.dataGrid.getSkin();
        if (skin == null) {
            throw new TypeCastException("null cannot be cast to non-null type tornadofx.DataGridSkin<T>");
        }
        DataGridSkin skin2 = (DataGridSkin)skin;
        int cellsPerRow = skin2.computeMaxCellsInRow();
        int rowIndex = index / cellsPerRow;
        DataGridRow dataGridRow = skin2.getRow(rowIndex);
        if (dataGridRow == null) {
            return null;
        }
        DataGridRow row = dataGridRow;
        int indexInRow = index - rowIndex * cellsPerRow;
        ObservableList children = row.getChildrenUnmodifiable();
        return children.size() > indexInRow ? (DataGridCell)((Object)children.get(indexInRow)) : (DataGridCell)null;
    }

    public void selectPrevious() {
        this.select(this.getSelectedIndex() - 1);
    }

    public void selectFirst() {
        this.select(0);
    }

    public void selectLast() {
        this.select(CollectionsKt.getLastIndex((List)((List)this.dataGrid.getItems())));
    }

    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndicies;
    }

    public void clearAndSelect(int index) {
        this.selectedIndicies.clear();
        this.selectedItems.clear();
        this.select(index);
    }

    public ObservableList<T> getSelectedItems() {
        return this.selectedItems;
    }

    public void selectNext() {
        this.select(this.getSelectedIndex() + 1);
    }

    /*
     * WARNING - void declaration
     */
    public void selectAll() {
        this.selectedIndicies.clear();
        this.selectedItems.clear();
        Iterable $receiver$iv = (Iterable)this.dataGrid.getItems();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void item;
            int n = index$iv++;
            Object t2 = item$iv;
            int index = n;
            this.selectedIndicies.add((Object)index);
            this.selectedItems.add((Object)item);
        }
        this.select(CollectionsKt.getLastIndex((List)((List)this.dataGrid.getItems())));
    }

    public void clearSelection(int index) {
        if (this.selectedIndicies.contains((Object)index)) {
            this.selectedIndicies.remove((Object)index);
            this.selectedItems.remove(this.dataGrid.getItems().get(index));
        }
        if (this.getSelectedIndex() == index) {
            this.setSelectedIndex(-1);
            this.setSelectedItem(null);
        }
    }

    public void clearSelection() {
        this.selectedIndicies.clear();
        this.selectedItems.clear();
        this.setSelectedItem(null);
        this.setSelectedIndex(-1);
    }

    public boolean isEmpty() {
        return this.selectedIndicies.isEmpty();
    }

    public void selectIndices(int index, int ... indices) {
        Intrinsics.checkParameterIsNotNull((Object)indices, (String)"indices");
        this.select(index);
        int[] $receiver$iv = indices;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            int element$iv;
            int it = element$iv = $receiver$iv[i];
            this.select(it);
        }
    }

    public boolean isSelected(int index) {
        return this.selectedIndicies.contains((Object)index);
    }

    public void select(T obj) {
        int index = this.dataGrid.getItems().indexOf(obj);
        this.select(index);
    }

    public void select(int index) {
        if (index < 0 || index >= this.dataGrid.getItems().size()) {
            return;
        }
        this.setSelectedIndex(index);
        this.setSelectedItem(this.dataGrid.getItems().get(index));
        if (Intrinsics.areEqual((Object)this.getSelectionMode(), (Object)SelectionMode.SINGLE)) {
            CollectionsKt.removeAll((List)((List)this.selectedIndicies), (Function1)((Function1)new Function1<Integer, Boolean>(index){
                final /* synthetic */ int $index;

                public final boolean invoke(Integer it) {
                    return Intrinsics.areEqual((Object)it, (Object)this.$index) ^ true;
                }
                {
                    this.$index = n;
                    super(1);
                }
            }));
            CollectionsKt.removeAll((List)((List)this.selectedItems), (Function1)new Function1<T, Boolean>(this){
                final /* synthetic */ DataGridSelectionModel this$0;

                public final boolean invoke(T it) {
                    return Intrinsics.areEqual(it, (Object)this.this$0.getSelectedItem()) ^ true;
                }
                {
                    this.this$0 = dataGridSelectionModel;
                    super(1);
                }
            });
        }
        if (!this.selectedIndicies.contains((Object)index)) {
            this.selectedIndicies.add((Object)index);
            this.selectedItems.add(this.getSelectedItem());
            this.dataGrid.getFocusModel().focus(index);
        }
    }

    public final void clearSelectionAndReapply() {
        List currentItems = CollectionsKt.toList((Iterable)((Iterable)this.selectedItems));
        this.clearSelection();
        for (Object item : currentItems) {
            int index = this.dataGrid.getItems().indexOf(item);
            this.select(index);
        }
    }

    @NotNull
    public final DataGrid<T> getDataGrid() {
        return this.dataGrid;
    }

    public DataGridSelectionModel(@NotNull DataGrid<T> dataGrid) {
        Intrinsics.checkParameterIsNotNull(dataGrid, (String)"dataGrid");
        this.dataGrid = dataGrid;
        this.selectedIndicies = FXCollections.observableArrayList();
        this.selectedItems = FXCollections.observableArrayList();
        ListChangeListener selectedIndicesListener2 = (ListChangeListener)new ListChangeListener<Integer>(this){
            final /* synthetic */ DataGridSelectionModel this$0;

            public final void onChanged(ListChangeListener.Change<? extends Integer> c) {
                while (c.next()) {
                    DataGridCell<T> cell;
                    Integer index;
                    Iterable $receiver$iv;
                    if (c.wasAdded()) {
                        $receiver$iv = c.getAddedSubList();
                        for (T element$iv : $receiver$iv) {
                            index = (Integer)element$iv;
                            cell = this.this$0.getCellAt(index);
                            if (cell == null || cell.isSelected()) continue;
                            cell.setUpdating(true);
                            cell.updateSelected(true);
                            cell.doUpdateItem$tornadofx();
                            cell.setUpdating(false);
                        }
                    }
                    if (!c.wasRemoved()) continue;
                    $receiver$iv = c.getRemoved();
                    for (T element$iv : $receiver$iv) {
                        index = (Integer)element$iv;
                        cell = this.this$0.getCellAt(index);
                        if (cell == null || !cell.isSelected()) continue;
                        cell.setUpdating(true);
                        cell.updateSelected(false);
                        cell.doUpdateItem$tornadofx();
                        cell.setUpdating(false);
                    }
                }
            }
            {
                this.this$0 = dataGridSelectionModel;
            }
        };
        this.getSelectedIndices().addListener(selectedIndicesListener2);
    }

    public static final /* synthetic */ void access$setSelectedItem(DataGridSelectionModel $this, Object p0) {
        $this.setSelectedItem(p0);
    }
}

