/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.HttpURLEngine;
import tornadofx.HttpURLResponse;
import tornadofx.JsonModel;
import tornadofx.Rest;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0017H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"Ltornadofx/HttpURLRequest;", "Ltornadofx/Rest$Request;", "engine", "Ltornadofx/HttpURLEngine;", "seq", "", "method", "Ltornadofx/Rest$Request$Method;", "uri", "Ljava/net/URI;", "entity", "", "(Ltornadofx/HttpURLEngine;JLtornadofx/Rest$Request$Method;Ljava/net/URI;Ljava/lang/Object;)V", "connection", "Ljava/net/HttpURLConnection;", "getConnection", "()Ljava/net/HttpURLConnection;", "getEngine", "()Ltornadofx/HttpURLEngine;", "getEntity", "()Ljava/lang/Object;", "headers", "", "", "getHeaders", "()Ljava/util/Map;", "getMethod", "()Ltornadofx/Rest$Request$Method;", "getSeq", "()J", "getUri", "()Ljava/net/URI;", "addHeader", "", "name", "value", "execute", "Ltornadofx/Rest$Response;", "tornadofx"})
public final class HttpURLRequest
implements Rest.Request {
    @NotNull
    private final HttpURLConnection connection;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final HttpURLEngine engine;
    private final long seq;
    @NotNull
    private final Rest.Request.Method method;
    @NotNull
    private final URI uri;
    @Nullable
    private final Object entity;

    @NotNull
    public final HttpURLConnection getConnection() {
        return this.connection;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Rest.Response execute() {
        Function1<Rest.Request, Unit> function1 = this.engine.getAuthInterceptor();
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this);
        }
        Object object = this.headers;
        for (Map.Entry<String, String> entry : object.entrySet()) {
            this.connection.addRequestProperty(entry.getKey(), entry.getValue());
        }
        this.connection.setRequestMethod(this.getMethod().toString());
        if (this.getEntity() != null) {
            Object object2;
            if (this.headers.get("Content-Type") == null) {
                this.connection.addRequestProperty("Content-Type", "application/json");
            }
            this.connection.setDoOutput(true);
            this.connection.connect();
            Object object3 = this.getEntity();
            if (object3 instanceof JsonModel) {
                OutputStream outputStream = this.connection.getOutputStream();
                object2 = ((JsonModel)this.getEntity()).toJSON().toString();
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
                object = charset;
                OutputStream outputStream2 = outputStream;
                Object object4 = object2;
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object4).getBytes((Charset)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                outputStream2.write(byArray2);
            } else if (object3 instanceof JsonValue) {
                OutputStream outputStream = this.connection.getOutputStream();
                object2 = this.getEntity().toString();
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
                object = charset;
                OutputStream outputStream3 = outputStream;
                Object object5 = object2;
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object5).getBytes((Charset)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray3 = byArray;
                outputStream3.write(byArray3);
            } else {
                if (!(object3 instanceof InputStream)) throw (Throwable)new IllegalArgumentException("Don't know how to handle entity of type " + this.getEntity().getClass());
                this.connection.getOutputStream().write(ByteStreamsKt.readBytes$default((InputStream)((InputStream)this.getEntity()), (int)0, (int)1, null));
            }
        } else {
            this.connection.connect();
        }
        HttpURLResponse httpURLResponse = new HttpURLResponse(this);
        Function1<Rest.Response, Unit> function12 = this.engine.getResponseInterceptor();
        if (function12 == null) return httpURLResponse;
        Unit cfr_ignored_1 = (Unit)function12.invoke((Object)httpURLResponse);
        return httpURLResponse;
    }

    @Override
    public void addHeader(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Map<String, String> map = this.headers;
        String string = value2;
        map.put(name, string);
    }

    @NotNull
    public final HttpURLEngine getEngine() {
        return this.engine;
    }

    @Override
    public long getSeq() {
        return this.seq;
    }

    @Override
    @NotNull
    public Rest.Request.Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public URI getUri() {
        return this.uri;
    }

    @Override
    @Nullable
    public Object getEntity() {
        return this.entity;
    }

    public HttpURLRequest(@NotNull HttpURLEngine engine, long seq, @NotNull Rest.Request.Method method, @NotNull URI uri, @Nullable Object entity) {
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.engine = engine;
        this.seq = seq;
        this.method = method;
        this.uri = uri;
        this.entity = entity;
        this.headers = MapsKt.mutableMapOf((Pair[])new Pair[0]);
        URLConnection uRLConnection = this.getUri().toURL().openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        this.connection = (HttpURLConnection)uRLConnection;
        Map<String, String> map = this.headers;
        Pair pair = TuplesKt.to((Object)"Accept-Encoding", (Object)"gzip, deflate");
        map.put((String)pair.getFirst(), (String)pair.getSecond());
        map = this.headers;
        pair = TuplesKt.to((Object)"Content-Type", (Object)"application/json");
        map.put((String)pair.getFirst(), (String)pair.getSecond());
        map = this.headers;
        pair = TuplesKt.to((Object)"Accept", (Object)"application/json");
        map.put((String)pair.getFirst(), (String)pair.getSecond());
    }
}

