/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import tornadofx.ItemControlsKt;
import tornadofx.NodesKt;
import tornadofx.ResizeType;
import tornadofx.SmartResize;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\f\u001a\u00020\u00042\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002H\u0017\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\bR,\u0010\u0007\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0006\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Ltornadofx/SmartResize;", "Ljavafx/util/Callback;", "Ljavafx/scene/control/TableView$ResizeFeatures;", "", "", "()V", "value", "isSmartResizing", "Ljavafx/scene/control/TableView;", "(Ljavafx/scene/control/TableView;)Z", "setSmartResizing", "(Ljavafx/scene/control/TableView;Z)V", "call", "param", "(Ljavafx/scene/control/TableView$ResizeFeatures;)Ljava/lang/Boolean;", "requestResize", "", "table", "Companion", "tornadofx"})
public final class SmartResize
implements Callback<TableView.ResizeFeatures<? extends Object>, Boolean> {
    @NotNull
    private static final SmartResize POLICY;
    @NotNull
    private static final String ResizeTypeKey = "tornadofx.smartColumnResizeType";
    private static final ChangeListener<Callback<TableView.ResizeFeatures<?>, Boolean>> policyChangeListener;
    private static final ListChangeListener<TableColumn<?, ?>> columnsChangeListener;
    private static final ChangeListener<Number> columnWidthChangeListener;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Boolean call(@NotNull TableView.ResizeFeatures<? extends Object> param) {
        Intrinsics.checkParameterIsNotNull(param, (String)"param");
        this.setSmartResizing(param.getTable(), true);
        try {
            if (param.getColumn() == null) {
                Collection $receiver$iv;
                void remainingWidth;
                Object weight$;
                Iterable<Object> destination$iv$iv;
                Object it;
                void $receiver$iv$iv8;
                void destination$iv$iv2;
                Iterable $receiver$iv$iv2;
                Collection $receiver$iv2;
                Collection $receiver$iv3;
                Iterable destination$iv$iv3;
                TableColumn it2;
                Iterable $receiver$iv$iv3;
                Collection $receiver$iv4;
                Object rt;
                Object element$iv4;
                void destination$iv$iv4;
                Iterable $receiver$iv$iv4;
                Iterable $receiver$iv5;
                Object rt2;
                Object it3;
                Object element$iv22;
                void destination$iv$iv5;
                Iterable $receiver$iv$iv5;
                Iterable $receiver$iv6;
                Object rt3;
                Object it4;
                Object element$iv32;
                void destination$iv$iv6;
                Object it5;
                Iterable $receiver$iv$iv6;
                Iterable $receiver$iv7;
                double contentWidth = ItemControlsKt.getContentWidth(param.getTable());
                if (contentWidth == 0.0) {
                    Boolean bl = false;
                    return bl;
                }
                TableView tableView = param.getTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)tableView, (String)"param.table");
                if (!SmartResize.Companion.isPolicyInstalled(tableView)) {
                    TableView tableView2 = param.getTable();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tableView2, (String)"param.table");
                    SmartResize.Companion.install(tableView2);
                }
                Ref.DoubleRef doubleRef = new Ref.DoubleRef();
                doubleRef.element = contentWidth;
                Iterable iterable = (Iterable)param.getTable().getColumns();
                void var7_9 = $receiver$iv7;
                Collection collection = new ArrayList();
                Iterator iterator = $receiver$iv$iv6.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    it5 = (TableColumn)element$iv$iv;
                    if (!(ItemControlsKt.getResizeType(it5) instanceof ResizeType.Fixed)) continue;
                    destination$iv$iv6.add(element$iv$iv);
                }
                List fixedColumns = (List)destination$iv$iv6;
                $receiver$iv7 = fixedColumns;
                for (Object element$iv32 : $receiver$iv7) {
                    it4 = (TableColumn)element$iv32;
                    ResizeType resizeType = ItemControlsKt.getResizeType(it4);
                    if (resizeType == null) {
                        throw new TypeCastException("null cannot be cast to non-null type tornadofx.ResizeType.Fixed");
                    }
                    rt3 = (ResizeType.Fixed)resizeType;
                    it4.setPrefWidth(((ResizeType.Fixed)rt3).getWidth());
                    remainingWidth.element -= it4.getWidth();
                }
                $receiver$iv$iv6 = (Iterable)param.getTable().getColumns();
                element$iv32 = $receiver$iv6;
                it4 = new ArrayList();
                rt3 = $receiver$iv$iv5.iterator();
                while (rt3.hasNext()) {
                    Object element$iv$iv = rt3.next();
                    TableColumn it6 = (TableColumn)element$iv$iv;
                    if (!(ItemControlsKt.getResizeType(it6) instanceof ResizeType.Pref)) continue;
                    destination$iv$iv5.add(element$iv$iv);
                }
                List prefColumns = (List)destination$iv$iv5;
                $receiver$iv6 = prefColumns;
                for (Object element$iv22 : $receiver$iv6) {
                    it3 = (TableColumn)element$iv22;
                    ResizeType resizeType = ItemControlsKt.getResizeType(it3);
                    if (resizeType == null) {
                        throw new TypeCastException("null cannot be cast to non-null type tornadofx.ResizeType.Pref");
                    }
                    rt2 = (ResizeType.Pref)resizeType;
                    it3.setPrefWidth(((ResizeType.Pref)rt2).getWidth() + ((ResizeType)rt2).getDelta());
                    remainingWidth.element -= it3.getWidth();
                }
                $receiver$iv$iv5 = (Iterable)param.getTable().getColumns();
                element$iv22 = $receiver$iv5;
                it3 = new ArrayList();
                rt2 = $receiver$iv$iv4.iterator();
                while (rt2.hasNext()) {
                    Object element$iv$iv = rt2.next();
                    TableColumn it7 = (TableColumn)element$iv$iv;
                    if (!(ItemControlsKt.getResizeType(it7) instanceof ResizeType.Content)) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                List contentColumns = (List)destination$iv$iv4;
                NodesKt.resizeColumnsToFitContent$default(param.getTable(), contentColumns, 0, null, 6, null);
                $receiver$iv5 = contentColumns;
                for (Object element$iv4 : $receiver$iv5) {
                    it5 = (TableColumn)element$iv4;
                    ResizeType resizeType = ItemControlsKt.getResizeType(it5);
                    if (resizeType == null) {
                        throw new TypeCastException("null cannot be cast to non-null type tornadofx.ResizeType.Content");
                    }
                    rt = (ResizeType.Content)resizeType;
                    it5.setPrefWidth(it5.getWidth() + ((ResizeType)rt).getDelta() + ((ResizeType.Content)rt).getPadding());
                    if (((ResizeType.Content)rt).getUseAsMin() && !((ResizeType.Content)rt).getMinRecorded() && it5.getWidth() != 80.0) {
                        it5.setMinWidth(it5.getWidth());
                        ((ResizeType.Content)rt).setMinRecorded(true);
                    }
                    if (((ResizeType.Content)rt).getUseAsMax() && !((ResizeType.Content)rt).getMaxRecorded() && it5.getWidth() != 80.0) {
                        it5.setMaxWidth(it5.getWidth());
                        ((ResizeType.Content)rt).setMaxRecorded(true);
                    }
                    remainingWidth.element -= it5.getWidth();
                }
                $receiver$iv$iv4 = (Iterable)param.getTable().getColumns();
                element$iv4 = $receiver$iv4;
                it5 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv3) {
                    it2 = (TableColumn)element$iv$iv;
                    if (!(ItemControlsKt.getResizeType(it2) instanceof ResizeType.Pct)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                List pctColumns = (List)destination$iv$iv3;
                $receiver$iv4 = pctColumns;
                if (!$receiver$iv4.isEmpty()) {
                    double widthPerPct = contentWidth / 100.0;
                    destination$iv$iv3 = pctColumns;
                    for (Object element$iv5 : $receiver$iv3) {
                        it2 = (TableColumn)element$iv5;
                        ResizeType resizeType = ItemControlsKt.getResizeType(it2);
                        if (resizeType == null) {
                            throw new TypeCastException("null cannot be cast to non-null type tornadofx.ResizeType.Pct");
                        }
                        ResizeType.Pct rt4 = (ResizeType.Pct)resizeType;
                        it2.setPrefWidth(widthPerPct * rt4.getValue() + rt4.getDelta());
                        remainingWidth.element -= it2.getWidth();
                    }
                }
                $receiver$iv$iv3 = (Iterable)param.getTable().getColumns();
                $receiver$iv3 = $receiver$iv2;
                rt = new ArrayList();
                for (Object element$iv$iv2 : $receiver$iv$iv2) {
                    TableColumn it8 = (TableColumn)element$iv$iv2;
                    if (!(ItemControlsKt.getResizeType(it8) instanceof ResizeType.Weight)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                List weightColumns = (List)destination$iv$iv2;
                $receiver$iv2 = weightColumns;
                if (!$receiver$iv2.isEmpty()) {
                    void $receiver$iv8;
                    TableColumn it9;
                    Iterable destination$iv$iv7;
                    void $receiver$iv$iv7;
                    void $receiver$iv9;
                    Object element$iv$iv3;
                    Object element$iv$iv2;
                    Object element$iv5;
                    $receiver$iv$iv2 = (Iterable)param.getTable().getColumns();
                    Collection collection2 = weightColumns;
                    destination$iv$iv2 = $receiver$iv3;
                    element$iv5 = new ArrayList();
                    for (Object element$iv$iv3 : $receiver$iv$iv8) {
                        it = (TableColumn)element$iv$iv3;
                        if (!(ItemControlsKt.getResizeType(it) instanceof ResizeType.Remaining)) continue;
                        destination$iv$iv.add(element$iv$iv3);
                    }
                    Object object = (List)destination$iv$iv;
                    List consideredColumns = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)object));
                    weight$ = call.5.INSTANCE;
                    element$iv$iv2 = consideredColumns;
                    element$iv$iv3 = $receiver$iv9;
                    it = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv9, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv7) {
                        TableColumn $i$f$filter = (TableColumn)item$iv$iv;
                        collection2 = destination$iv$iv7;
                        object = call.5.INSTANCE.invoke(it9);
                        collection2.add(object);
                    }
                    double totalWeight = CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv7));
                    double perWeight = remainingWidth.element / totalWeight;
                    destination$iv$iv7 = consideredColumns;
                    for (Object element$iv6 : $receiver$iv8) {
                        it9 = (TableColumn)element$iv6;
                        ResizeType rt5 = ItemControlsKt.getResizeType(it9);
                        if (rt5 instanceof ResizeType.Weight) {
                            if (((ResizeType.Weight)rt5).getMinContentWidth() && !((ResizeType.Weight)rt5).getMinRecorded()) {
                                ((ResizeType.Weight)rt5).setMinRecorded(true);
                                it9.setMinWidth(it9.getWidth() + ((ResizeType.Weight)rt5).getPadding());
                            }
                            it9.setPrefWidth(Math.max(it9.getMinWidth(), perWeight * ((ResizeType.Weight)rt5).getWeight() + rt5.getDelta() + ((ResizeType.Weight)rt5).getPadding()));
                        } else {
                            it9.setPrefWidth(Math.max(it9.getMinWidth(), perWeight + rt5.getDelta()));
                        }
                        remainingWidth.element -= it9.getWidth();
                    }
                } else {
                    weight$ = (Iterable)param.getTable().getColumns();
                    void totalWeight = $receiver$iv3;
                    destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv3 : $receiver$iv$iv8) {
                        it = (TableColumn)element$iv$iv3;
                        if (!(ItemControlsKt.getResizeType(it) instanceof ResizeType.Remaining)) continue;
                        destination$iv$iv.add(element$iv$iv3);
                    }
                    List remainingColumns = (List)destination$iv$iv;
                    $receiver$iv3 = remainingColumns;
                    if (!$receiver$iv3.isEmpty() && remainingWidth.element > 0.0) {
                        double perColumn = remainingWidth.element / (double)remainingColumns.size();
                        destination$iv$iv = remainingColumns;
                        for (Object element$iv7 : $receiver$iv) {
                            it = (TableColumn)element$iv7;
                            it.setPrefWidth(perColumn + ItemControlsKt.getResizeType(it).getDelta());
                            remainingWidth.element -= it.getWidth();
                        }
                    }
                }
                if (remainingWidth.element > 0.0) {
                    TableColumn rightMostResizable;
                    Iterable perColumn = CollectionsKt.reversed((Iterable)((Iterable)param.getTable().getColumns()));
                    void $receiver$iv$iv8 = $receiver$iv10;
                    $receiver$iv = new ArrayList();
                    for (Object element$iv$iv3 : $receiver$iv$iv8) {
                        it = (TableColumn)element$iv$iv3;
                        if (!ItemControlsKt.getResizeType(it).isResizable()) continue;
                        destination$iv$iv.add(element$iv$iv3);
                    }
                    TableColumn tableColumn = rightMostResizable = (TableColumn)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    if (tableColumn != null) {
                        TableColumn $receiver$iv10 = tableColumn;
                        TableColumn $receiver = $receiver$iv10;
                        $receiver.setPrefWidth($receiver.getWidth() + remainingWidth.element);
                        remainingWidth.element -= $receiver.getWidth();
                    }
                } else if (remainingWidth.element < 0.0) {
                    boolean canReduceMore = true;
                    while (canReduceMore && remainingWidth.element < 0.0) {
                        Comparator destination$iv$iv8;
                        Iterable $receiver$iv$iv9;
                        Iterable $receiver$iv11;
                        Iterable $receiver = (Iterable)param.getTable().getColumns();
                        void $i$a$8$apply = $receiver$iv11;
                        Collection perWeight = new ArrayList();
                        for (Object element$iv$iv : $receiver$iv$iv9) {
                            TableColumn it10 = (TableColumn)element$iv$iv;
                            if (!(ItemControlsKt.getResizeType(it10).isResizable() && it10.getMinWidth() < it10.getWidth())) continue;
                            destination$iv$iv8.add(element$iv$iv);
                        }
                        $receiver$iv11 = (List)((Object)destination$iv$iv8);
                        $receiver$iv$iv9 = $receiver$iv11;
                        destination$iv$iv8 = new Comparator<TableColumn<? extends Object, ? extends Object>>(){

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public int compare(Object a, Object b) {
                                TableColumn it = (TableColumn)a;
                                Comparable comparable = Double.valueOf((it.getWidth() - it.getMinWidth()) * (double)-1);
                                it = (TableColumn)b;
                                Comparable comparable2 = comparable;
                                Double d = (it.getWidth() - it.getMinWidth()) * (double)-1;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                            }
                        };
                        TableColumn reduceableCandidate = (TableColumn)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)$receiver$iv$iv9, (Comparator)destination$iv$iv8));
                        boolean bl = canReduceMore = reduceableCandidate != null;
                        if (reduceableCandidate == null || !(remainingWidth.element < 0.0)) continue;
                        double reduceBy = Math.min(1.0, Math.abs(remainingWidth.element));
                        double toWidth = reduceableCandidate.getWidth() - reduceBy;
                        ResizeType resizeType = ItemControlsKt.getResizeType(reduceableCandidate);
                        resizeType.setDelta(resizeType.getDelta() - reduceBy);
                        reduceableCandidate.setPrefWidth(toWidth);
                        remainingWidth.element += reduceBy;
                    }
                }
                doubleRef = null;
            } else {
                TableColumn tableColumn;
                Collection destination$iv$iv;
                void $receiver$iv$iv$iv;
                Iterable $receiver$iv$iv;
                Object $receiver$iv;
                ResizeType rt = ItemControlsKt.getResizeType(param.getColumn());
                if (!rt.isResizable()) {
                    Boolean bl = false;
                    return bl;
                }
                double targetWidth = param.getColumn().getWidth() + param.getDelta();
                if (Double.compare(targetWidth, param.getColumn().minWidthProperty().getValue()) < 0 || Double.compare(targetWidth, param.getColumn().maxWidthProperty().getValue()) > 0) {
                    Boolean fixedColumns = false;
                    return fixedColumns;
                }
                double rightColDelta = param.getDelta() * -1.0;
                int colIndex = CollectionsKt.indexOf((List)((List)param.getTable().getColumns()), (Object)param.getColumn());
                Iterable weightColumns = (Iterable)param.getTable().getColumns();
                void canReduceMore = $receiver$iv;
                Collection reduceableCandidate = new ArrayList();
                void reduceBy = $receiver$iv$iv;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
                    void c;
                    int n = index$iv$iv$iv++;
                    Object element$iv$iv = item$iv$iv$iv;
                    int index$iv$iv = n;
                    TableColumn $i$a$1$filter = (TableColumn)element$iv$iv;
                    int i = index$iv$iv;
                    if (!(i > colIndex && ItemControlsKt.getResizeType(c).isResizable())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    TableColumn it = (TableColumn)element$iv$iv;
                    double newWidth = it.getWidth() + rightColDelta;
                    if (!(Double.compare(newWidth, it.maxWidthProperty().getValue()) <= 0 && Double.compare(newWidth, it.minWidthProperty().getValue()) >= 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                if ((TableColumn)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)) == null) {
                    $receiver$iv = false;
                    return $receiver$iv;
                }
                TableColumn rightCol = tableColumn;
                TableColumn $receiver = rightCol;
                ResizeType resizeType = ItemControlsKt.getResizeType($receiver);
                resizeType.setDelta(resizeType.getDelta() + rightColDelta);
                $receiver.setPrefWidth($receiver.getWidth() + rightColDelta);
                TableColumn tableColumn2 = param.getColumn();
                TableColumn $receiver2 = tableColumn2;
                ResizeType resizeType2 = rt;
                resizeType2.setDelta(resizeType2.getDelta() + param.getDelta());
                $receiver2.setPrefWidth($receiver2.getWidth() + param.getDelta());
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            this.setSmartResizing(param.getTable(), false);
        }
    }

    public final boolean isSmartResizing(@NotNull TableView<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getProperties().get((Object)"tornadofx.isSmartResizing"), (Object)true);
    }

    public final void setSmartResizing(@NotNull TableView<?> $receiver, boolean value2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Map map = (Map)$receiver.getProperties();
        String string = "tornadofx.isSmartResizing";
        Boolean bl = value2;
        map.put(string, bl);
    }

    public final void requestResize(@NotNull TableView<?> table) {
        Intrinsics.checkParameterIsNotNull(table, (String)"table");
        this.call((TableView.ResizeFeatures<? extends Object>)new TableView.ResizeFeatures(table, (TableColumn)null, Double.valueOf(0.0)));
    }

    private SmartResize() {
    }

    static {
        Companion = new Companion(null);
        POLICY = new SmartResize();
        ResizeTypeKey = ResizeTypeKey;
        policyChangeListener = Companion.policyChangeListener.1.INSTANCE;
        columnsChangeListener = Companion.columnsChangeListener.1.INSTANCE;
        columnWidthChangeListener = Companion.columnWidthChangeListener.1.INSTANCE;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\"\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0014\u0010%\u001a\u00020\u00192\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0014\u0010&\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0002X\u0083\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0004\u0012\u00020\u00190\u00170\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R,\u0010\u001c\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u00198@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006'"}, d2={"Ltornadofx/SmartResize$Companion;", "", "()V", "POLICY", "Ltornadofx/SmartResize;", "getPOLICY", "()Ltornadofx/SmartResize;", "ResizeTypeKey", "", "getResizeTypeKey", "()Ljava/lang/String;", "columnWidthChangeListener", "Ljavafx/beans/value/ChangeListener;", "", "columnWidthChangeListener$annotations", "getColumnWidthChangeListener", "()Ljavafx/beans/value/ChangeListener;", "columnsChangeListener", "Ljavafx/collections/ListChangeListener;", "Ljavafx/scene/control/TableColumn;", "getColumnsChangeListener", "()Ljavafx/collections/ListChangeListener;", "policyChangeListener", "Ljavafx/util/Callback;", "Ljavafx/scene/control/TableView$ResizeFeatures;", "", "getPolicyChangeListener", "value", "isSmartResizing", "Ljavafx/scene/control/TableView;", "isSmartResizing$tornadofx", "(Ljavafx/scene/control/TableView;)Z", "setSmartResizing$tornadofx", "(Ljavafx/scene/control/TableView;Z)V", "install", "", "table", "isPolicyInstalled", "uninstall", "tornadofx"})
    public static final class Companion {
        @NotNull
        public final SmartResize getPOLICY() {
            return POLICY;
        }

        @NotNull
        public final String getResizeTypeKey() {
            return ResizeTypeKey;
        }

        public final boolean isSmartResizing$tornadofx(@NotNull TableView<?> $receiver) {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            return Intrinsics.areEqual((Object)$receiver.getProperties().get((Object)"tornadofx.isSmartResizing"), (Object)true);
        }

        public final void setSmartResizing$tornadofx(@NotNull TableView<?> $receiver, boolean value2) {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Map map = (Map)$receiver.getProperties();
            String string = "tornadofx.isSmartResizing";
            Boolean bl = value2;
            map.put(string, bl);
        }

        private final ChangeListener<Callback<TableView.ResizeFeatures<?>, Boolean>> getPolicyChangeListener() {
            return policyChangeListener;
        }

        private final ListChangeListener<TableColumn<?, ?>> getColumnsChangeListener() {
            return columnsChangeListener;
        }

        private static final /* synthetic */ void columnWidthChangeListener$annotations() {
        }

        private final ChangeListener<Number> getColumnWidthChangeListener() {
            return columnWidthChangeListener;
        }

        private final boolean isPolicyInstalled(TableView<?> table) {
            return Intrinsics.areEqual((Object)table.getProperties().get((Object)"tornadofx.smartResizeInstalled"), (Object)true);
        }

        private final void install(TableView<?> table) {
            table.columnResizePolicyProperty().addListener(this.getPolicyChangeListener());
            table.getColumns().addListener(this.getColumnsChangeListener());
            Iterable $receiver$iv = (Iterable)table.getColumns();
            for (Object element$iv : $receiver$iv) {
                TableColumn it = (TableColumn)element$iv;
                it.widthProperty().addListener(Companion.getColumnWidthChangeListener());
            }
            Map map = (Map)table.getProperties();
            String string = "tornadofx.smartResizeInstalled";
            Boolean bl = true;
            map.put(string, bl);
        }

        private final void uninstall(TableView<?> table) {
            table.columnResizePolicyProperty().removeListener(this.getPolicyChangeListener());
            table.getColumns().removeListener(this.getColumnsChangeListener());
            Iterable $receiver$iv = (Iterable)table.getColumns();
            for (Object element$iv : $receiver$iv) {
                TableColumn it = (TableColumn)element$iv;
                it.widthProperty().removeListener(Companion.getColumnWidthChangeListener());
            }
            table.getProperties().remove((Object)"tornadofx.smartResizeInstalled");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ void access$uninstall(Companion $this, @NotNull TableView table) {
            $this.uninstall(table);
        }

        @NotNull
        public static final /* synthetic */ ChangeListener access$getColumnWidthChangeListener$p(Companion $this) {
            return $this.getColumnWidthChangeListener();
        }
    }
}

