/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.DataGrid;
import tornadofx.DataGridCell;
import tornadofx.DataGridRow;
import tornadofx.DataGridRowSkin;
import tornadofx.DataGridSkin;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000?\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007*\u0001\u0012\u0018\u0000*\u0004\b\u0000\u0010\u00012 \u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00040\u0002B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0014J0\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0002J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J(\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0014J\b\u0010 \u001a\u00020\u0018H\u0002\u00a8\u0006!"}, d2={"Ltornadofx/DataGridRowSkin;", "T", "Lcom/sun/javafx/scene/control/skin/CellSkinBase;", "Ltornadofx/DataGridRow;", "Lcom/sun/javafx/scene/control/behavior/BehaviorBase;", "control", "(Ltornadofx/DataGridRow;)V", "computeMaxHeight", "", "width", "topInset", "rightInset", "bottomInset", "leftInset", "computePrefHeight", "createCell", "Ltornadofx/DataGridCell;", "createDefaultCell", "tornadofx/DataGridRowSkin$createDefaultCell$1", "()Ltornadofx/DataGridRowSkin$createDefaultCell$1;", "getCellAtIndex", "index", "", "handleControlPropertyChanged", "", "p", "", "layoutChildren", "x", "y", "w", "h", "updateCells", "tornadofx"})
public final class DataGridRowSkin<T>
extends CellSkinBase<DataGridRow<T>, BehaviorBase<DataGridRow<T>>> {
    protected void handleControlPropertyChanged(@NotNull String p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        super.handleControlPropertyChanged(p);
        switch (p) {
            case "INDEX": {
                this.updateCells();
                break;
            }
            case "WIDTH": {
                this.updateCells();
                break;
            }
            case "HEIGHT": {
                this.updateCells();
            }
        }
    }

    private final void updateCells() {
        int rowIndex = ((DataGridRow)this.getSkinnable()).getIndex();
        if (rowIndex > -1) {
            DataGrid dataGrid = ((DataGridRow)this.getSkinnable()).getDataGrid();
            Skin skin = dataGrid.getSkin();
            if (skin == null) {
                throw new TypeCastException("null cannot be cast to non-null type tornadofx.DataGridSkin<*>");
            }
            int maxCellsInRow = ((DataGridSkin)skin).computeMaxCellsInRow();
            int totalCellsInGrid = dataGrid.getItems().size();
            int startCellIndex = rowIndex * maxCellsInRow;
            int endCellIndex = startCellIndex + maxCellsInRow - 1;
            int cacheIndex = 0;
            int cellIndex = startCellIndex;
            while (cellIndex <= endCellIndex && cellIndex < totalCellsInGrid) {
                DataGridCell<T> cell = this.getCellAtIndex(cacheIndex);
                if (cell == null) {
                    cell = this.createCell();
                    this.getChildren().add(cell);
                }
                cell.setUpdating(true);
                cell.updateIndex(-1);
                cell.setUpdating(false);
                cell.updateIndex(cellIndex);
                ++cellIndex;
                ++cacheIndex;
            }
            this.getChildren().remove(cacheIndex, this.getChildren().size());
        }
    }

    private final DataGridCell<T> createCell() {
        Object object = ((DataGridRow)this.getSkinnable()).getDataGrid().getCellFactory();
        if (object == null || (object = (DataGridCell)((Object)object.invoke(((DataGridRow)this.getSkinnable()).getDataGrid()))) == null) {
            object = this.createDefaultCell();
        }
        return object;
    }

    private final createDefaultCell.1 createDefaultCell() {
        return new DataGridCell<T>(this, ((DataGridRow)this.getSkinnable()).getDataGrid()){
            final /* synthetic */ DataGridRowSkin this$0;

            protected void updateItem(@Nullable T item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    Function2<DataGridCell<T>, T, Unit> formatter = ((DataGridRow)this.this$0.getSkinnable()).getDataGrid().getCellFormat();
                    if (this.getCache() != null) {
                        this.setGraphic((Node)new StackPane(new Node[]{this.getCache()}));
                        Function2<DataGridCell<T>, T, Unit> function2 = formatter;
                        if (function2 != null) {
                            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)((Object)this), item);
                        }
                    } else if (formatter != null) {
                        formatter.invoke((Object)((Object)this), item);
                    } else {
                        this.setGraphic((Node)new StackPane(new Node[]{(Node)new Label(item.toString())}));
                    }
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
    }

    @Nullable
    public final DataGridCell<T> getCellAtIndex(int index) {
        if (index < this.getChildren().size()) {
            return (DataGridCell)((Object)this.getChildren().get(index));
        }
        return null;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        DataGrid dataGrid = ((DataGridRow)this.getSkinnable()).getDataGrid();
        Skin skin = dataGrid.getSkin();
        if (skin == null) {
            throw new TypeCastException("null cannot be cast to non-null type tornadofx.DataGridSkin<*>");
        }
        return dataGrid.getCellHeight() * (double)((DataGridSkin)skin).getItemCount();
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        DataGrid dataGrid = ((DataGridRow)this.getSkinnable()).getDataGrid();
        return dataGrid.getCellHeight() + dataGrid.getVerticalCellSpacing() * (double)2;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        DataGrid dataGrid = ((DataGridRow)this.getSkinnable()).getDataGrid();
        double cellWidth = dataGrid.getCellWidth();
        double cellHeight = dataGrid.getCellHeight();
        double horizontalCellSpacing = dataGrid.getHorizontalCellSpacing();
        double verticalCellSpacing = dataGrid.getVerticalCellSpacing();
        double xPos = 0.0;
        for (Node child : this.getChildren()) {
            child.resizeRelocate(xPos + horizontalCellSpacing, y + verticalCellSpacing, cellWidth, cellHeight);
            xPos += cellWidth + horizontalCellSpacing * (double)2;
        }
    }

    public DataGridRowSkin(@NotNull DataGridRow<T> control) {
        Intrinsics.checkParameterIsNotNull(control, (String)"control");
        super((Cell)control, new BehaviorBase((Control)control, CollectionsKt.emptyList()));
        this.getChildren().clear();
        this.updateCells();
        this.registerChangeListener((ObservableValue)((DataGridRow)this.getSkinnable()).indexProperty(), "INDEX");
        this.registerChangeListener((ObservableValue)((DataGridRow)this.getSkinnable()).widthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)((DataGridRow)this.getSkinnable()).heightProperty(), "HEIGHT");
    }
}

