/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.io.InputStream;
import java.net.URL;
import javax.json.JsonArray;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.Component;
import tornadofx.JsonKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0086\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Ltornadofx/ResourceLookup;", "", "component", "Ltornadofx/Component;", "(Ltornadofx/Component;)V", "getComponent", "()Ltornadofx/Component;", "get", "", "resource", "json", "Ljavax/json/JsonObject;", "jsonArray", "Ljavax/json/JsonArray;", "stream", "Ljava/io/InputStream;", "url", "Ljava/net/URL;", "tornadofx"})
public final class ResourceLookup {
    @NotNull
    private final Component component;

    @Nullable
    public final String get(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        URL uRL = this.component.getClass().getResource(resource);
        return uRL != null ? uRL.toExternalForm() : null;
    }

    @Nullable
    public final URL url(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        return this.component.getClass().getResource(resource);
    }

    @Nullable
    public final InputStream stream(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        return this.component.getClass().getResourceAsStream(resource);
    }

    @NotNull
    public final JsonObject json(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        InputStream inputStream = this.stream(resource);
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        return JsonKt.toJSON(inputStream);
    }

    @NotNull
    public final JsonArray jsonArray(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        InputStream inputStream = this.stream(resource);
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        return JsonKt.toJSONArray(inputStream);
    }

    @NotNull
    public final Component getComponent() {
        return this.component;
    }

    public ResourceLookup(@NotNull Component component) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        this.component = component;
    }
}

