/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.json.JsonArray;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.io.ConstantsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.Component;
import tornadofx.JsonKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0086\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Ltornadofx/ResourceLookup;", "", "component", "Ltornadofx/Component;", "(Ltornadofx/Component;)V", "getComponent", "()Ltornadofx/Component;", "get", "", "resource", "image", "Ljavafx/scene/image/Image;", "imageview", "Ljavafx/scene/image/ImageView;", "json", "Ljavax/json/JsonObject;", "jsonArray", "Ljavax/json/JsonArray;", "stream", "Ljava/io/InputStream;", "text", "url", "Ljava/net/URL;", "tornadofx"})
public final class ResourceLookup {
    @NotNull
    private final Component component;

    @Nullable
    public final String get(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        URL uRL = this.component.getClass().getResource(resource);
        return uRL != null ? uRL.toExternalForm() : null;
    }

    @Nullable
    public final URL url(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        return this.component.getClass().getResource(resource);
    }

    @Nullable
    public final InputStream stream(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        return this.component.getClass().getResourceAsStream(resource);
    }

    @NotNull
    public final Image image(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        return new Image(this.stream(resource));
    }

    @NotNull
    public final ImageView imageview(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        return new ImageView(new Image(this.stream(resource)));
    }

    @NotNull
    public final JsonObject json(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        InputStream inputStream = this.stream(resource);
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        return JsonKt.toJSON(inputStream);
    }

    @NotNull
    public final JsonArray jsonArray(@NotNull String resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        InputStream inputStream = this.stream(resource);
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        return JsonKt.toJSONArray(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String text(@NotNull String resource) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        InputStream inputStream = this.stream(resource);
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        Closeable closeable = inputStream;
        boolean bl = false;
        try {
            InputStream it;
            InputStream inputStream2 = it = (InputStream)closeable;
            Charset charset = null;
            boolean bl2 = true;
            Closeable closeable2 = null;
            if (closeable2 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferedReader");
            }
            if (bl2 & true) {
                charset = Charsets.UTF_8;
            }
            closeable2 = inputStream2;
            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
            int n = 0;
            boolean bl3 = true;
            Object var11_14 = null;
            if (var11_14 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
            }
            if (bl3 & true) {
                n = ConstantsKt.DEFAULT_BUFFER_SIZE;
            }
            string = TextStreamsKt.readText((Reader)(closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)));
        }
        catch (Exception exception) {
            bl = true;
            try {
                Closeable closeable3 = closeable;
                if (closeable3 != null) {
                    closeable3.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                Closeable closeable4 = closeable;
                if (closeable4 != null) {
                    closeable4.close();
                }
            }
        }
        return string;
    }

    @NotNull
    public final Component getComponent() {
        return this.component;
    }

    public ResourceLookup(@NotNull Component component) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        this.component = component;
    }
}

