/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.animation.SequentialTransition;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tornadofx.AnimationKt;
import tornadofx.NodesKt;
import tornadofx.UIComponent;
import tornadofx.ViewTransition;
import tornadofx.ViewTransition$Cover$WhenMappings;
import tornadofx.ViewTransition$Direction$WhenMappings;
import tornadofx.ViewTransition$Metro$WhenMappings;
import tornadofx.ViewTransition$Reveal$WhenMappings;
import tornadofx.ViewTransition$Slide$WhenMappings;
import tornadofx.ViewTransition$Swap$WhenMappings;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\b&\u0018\u0000 \u00192\u00020\u0001:\u000e\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\u0004H\u0000\u00a2\u0006\u0002\b\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0005H&J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001f\u0010\u0003\u001a\u00020\u00062\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000eH\u0004R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Ltornadofx/ViewTransition;", "", "()V", "setup", "Lkotlin/Function1;", "Ljavafx/scene/layout/StackPane;", "", "Lkotlin/ExtensionFunctionType;", "getSetup", "()Lkotlin/jvm/functions/Function1;", "setSetup", "(Lkotlin/jvm/functions/Function1;)V", "call", "current", "Ljavafx/scene/Node;", "replacement", "attach", "call$tornadofx", "create", "Ljavafx/animation/Animation;", "stack", "onComplete", "removed", "moveToTop", "node", "Companion", "Cover", "Direction", "Explode", "Fade", "FadeThrough", "Flip", "Implode", "Metro", "NewsFlash", "Reveal", "ReversibleViewTransition", "Slide", "Swap", "tornadofx"})
public abstract class ViewTransition {
    @NotNull
    private Function1<? super StackPane, Unit> setup = setup.1.INSTANCE;
    @NotNull
    private static final Function3<UIComponent, UIComponent, Function0<Unit>, Unit> SlideIn;
    @NotNull
    private static final Function3<UIComponent, UIComponent, Function0<Unit>, Unit> SlideOut;
    public static final Companion Companion;

    @NotNull
    public abstract Animation create(@NotNull Node var1, @NotNull Node var2, @NotNull StackPane var3);

    public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
        Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
    }

    @NotNull
    public final Function1<StackPane, Unit> getSetup() {
        return this.setup;
    }

    public final void setSetup(@NotNull Function1<? super StackPane, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.setup = function1;
    }

    public final void setup(@NotNull Function1<? super StackPane, Unit> setup2) {
        Intrinsics.checkParameterIsNotNull(setup2, (String)"setup");
        this.setup = setup2;
    }

    public final void call$tornadofx(@NotNull Node current, @NotNull Node replacement, @NotNull Function1<? super Node, Unit> attach2) {
        Animation animation;
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        Intrinsics.checkParameterIsNotNull(attach2, (String)"attach");
        NodesKt.setTransitioning(current, true);
        NodesKt.setTransitioning(replacement, true);
        Object object = current.getProperties().get((Object)"tornadofx.uicomponent");
        if (!(object instanceof UIComponent)) {
            object = null;
        }
        UIComponent currentUIComponent = (UIComponent)object;
        Object object2 = replacement.getProperties().get((Object)"tornadofx.uicomponent");
        if (!(object2 instanceof UIComponent)) {
            object2 = null;
        }
        UIComponent replacementUIComponent = (UIComponent)object2;
        UIComponent uIComponent = currentUIComponent;
        if (uIComponent != null) {
            uIComponent.setMuteDocking$tornadofx(true);
        }
        UIComponent uIComponent2 = replacementUIComponent;
        if (uIComponent2 != null) {
            uIComponent2.setMuteDocking$tornadofx(true);
        }
        StackPane stack = this.stack(current, replacement);
        this.setup.invoke((Object)stack);
        attach2.invoke((Object)stack);
        Animation $receiver = animation = this.create(current, replacement, stack);
        EventHandler oldFinish = $receiver.getOnFinished();
        $receiver.setOnFinished((EventHandler)new EventHandler<ActionEvent>(oldFinish, this, stack, current, replacement, currentUIComponent, replacementUIComponent, attach2){
            final /* synthetic */ EventHandler $oldFinish;
            final /* synthetic */ ViewTransition this$0;
            final /* synthetic */ StackPane $stack$inlined;
            final /* synthetic */ Node $current$inlined;
            final /* synthetic */ Node $replacement$inlined;
            final /* synthetic */ UIComponent $currentUIComponent$inlined;
            final /* synthetic */ UIComponent $replacementUIComponent$inlined;
            final /* synthetic */ Function1 $attach$inlined;
            {
                this.$oldFinish = eventHandler;
                this.this$0 = viewTransition;
                this.$stack$inlined = stackPane;
                this.$current$inlined = node;
                this.$replacement$inlined = node2;
                this.$currentUIComponent$inlined = uIComponent;
                this.$replacementUIComponent$inlined = uIComponent2;
                this.$attach$inlined = function1;
            }

            public final void handle(ActionEvent it) {
                this.$stack$inlined.getChildren().clear();
                NodesKt.removeFromParent((EventTarget)this.$current$inlined);
                NodesKt.removeFromParent((EventTarget)this.$replacement$inlined);
                NodesKt.removeFromParent((EventTarget)this.$stack$inlined);
                UIComponent uIComponent = this.$currentUIComponent$inlined;
                if (uIComponent != null) {
                    UIComponent uIComponent2;
                    UIComponent it2 = uIComponent2 = uIComponent;
                    it2.setMuteDocking$tornadofx(false);
                    it2.callOnUndock$tornadofx();
                }
                UIComponent uIComponent3 = this.$replacementUIComponent$inlined;
                if (uIComponent3 != null) {
                    uIComponent3.setMuteDocking$tornadofx(false);
                }
                this.$attach$inlined.invoke((Object)this.$replacement$inlined);
                EventHandler eventHandler = this.$oldFinish;
                if (eventHandler != null) {
                    eventHandler.handle((Event)it);
                }
                this.this$0.onComplete(this.$current$inlined, this.$replacement$inlined);
                NodesKt.setTransitioning(this.$current$inlined, false);
                NodesKt.setTransitioning(this.$replacement$inlined, false);
            }
        });
        animation.play();
    }

    protected final void moveToTop(@NotNull StackPane $receiver, @NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if ($receiver.getChildren().remove((Object)node)) {
            $receiver.getChildren().add((Object)node);
        }
    }

    @NotNull
    public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        return new StackPane(new Node[]{replacement, current});
    }

    static {
        Companion = new Companion(null);
        SlideIn = Companion.SlideIn.1.INSTANCE;
        SlideOut = Companion.SlideOut.1.INSTANCE;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0000j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ltornadofx/ViewTransition$Direction;", "", "(Ljava/lang/String;I)V", "reversed", "UP", "RIGHT", "DOWN", "LEFT", "tornadofx"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction UP;
        public static final /* enum */ Direction RIGHT;
        public static final /* enum */ Direction DOWN;
        public static final /* enum */ Direction LEFT;
        private static final /* synthetic */ Direction[] $VALUES;

        static {
            Direction[] directionArray = new Direction[4];
            Direction[] directionArray2 = directionArray;
            directionArray[0] = UP = new Direction();
            directionArray[1] = RIGHT = new Direction();
            directionArray[2] = DOWN = new Direction();
            directionArray[3] = LEFT = new Direction();
            $VALUES = directionArray;
        }

        @NotNull
        public final Direction reversed() {
            Direction direction;
            switch (ViewTransition$Direction$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    direction = DOWN;
                    break;
                }
                case 2: {
                    direction = LEFT;
                    break;
                }
                case 3: {
                    direction = UP;
                    break;
                }
                case 4: {
                    direction = RIGHT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return direction;
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String string) {
            return Enum.valueOf(Direction.class, string);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Ltornadofx/ViewTransition$Fade;", "Ltornadofx/ViewTransition;", "duration", "Ljavafx/util/Duration;", "(Ljavafx/util/Duration;)V", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/FadeTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "tornadofx"})
    public static final class Fade
    extends ViewTransition {
        @NotNull
        private final Duration duration;

        @NotNull
        public FadeTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            return AnimationKt.fade$default(current, this.duration, 0.0, null, false, false, null, 44, null);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            removed.setOpacity(1.0);
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        public Fade(@NotNull Duration duration) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            this.duration = duration;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Ltornadofx/ViewTransition$FadeThrough;", "Ltornadofx/ViewTransition;", "duration", "Ljavafx/util/Duration;", "color", "Ljavafx/scene/paint/Paint;", "(Ljavafx/util/Duration;Ljavafx/scene/paint/Paint;)V", "bg", "Ljavafx/scene/layout/Pane;", "getColor", "()Ljavafx/scene/paint/Paint;", "halfTime", "getHalfTime", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/SequentialTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "tornadofx"})
    public static final class FadeThrough
    extends ViewTransition {
        private final Pane bg;
        @NotNull
        private final Duration halfTime;
        @NotNull
        private final Paint color;

        @NotNull
        public final Duration getHalfTime() {
            return this.halfTime;
        }

        @NotNull
        public SequentialTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Interpolator interpolator = Interpolator.EASE_IN;
            Intrinsics.checkExpressionValueIsNotNull((Object)interpolator, (String)"Interpolator.EASE_IN");
            Animation animation = (Animation)AnimationKt.fade$default(current, this.halfTime, 0.0, interpolator, false, false, null, 40, null);
            Animation[] animationArray = new Animation[1];
            Interpolator interpolator2 = Interpolator.EASE_OUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)interpolator2, (String)"Interpolator.EASE_OUT");
            animationArray[0] = (Animation)AnimationKt.fade$default(replacement, this.halfTime, 0.0, interpolator2, true, false, null, 32, null);
            return AnimationKt.then$default(animation, animationArray, null, 2, null);
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            return new StackPane(new Node[]{(Node)this.bg, replacement, current});
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            removed.setOpacity(1.0);
        }

        @NotNull
        public final Paint getColor() {
            return this.color;
        }

        public FadeThrough(@NotNull Duration duration, @NotNull Paint color) {
            Pane pane;
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
            this.color = color;
            Pane pane2 = new Pane();
            FadeThrough fadeThrough = this;
            Pane $receiver = pane2;
            $receiver.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.color, null, null)}));
            fadeThrough.bg = pane = pane2;
            Duration duration2 = duration.divide(2.0);
            if (duration2 == null) {
                Intrinsics.throwNpe();
            }
            this.halfTime = duration2;
        }

        public /* synthetic */ FadeThrough(Duration duration, Paint paint, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                Color color = Color.TRANSPARENT;
                Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.TRANSPARENT");
                paint = (Paint)color;
            }
            this(duration, paint);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0001H&\u00a8\u0006\u0004"}, d2={"Ltornadofx/ViewTransition$ReversibleViewTransition;", "Ltornadofx/ViewTransition;", "()V", "reversed", "tornadofx"})
    public static abstract class ReversibleViewTransition
    extends ViewTransition {
        @NotNull
        public abstract ViewTransition reversed();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Ltornadofx/ViewTransition$Slide;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "tornadofx"})
    public static final class Slide
    extends ReversibleViewTransition {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Slide$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    point2D = new Point2D(0.0, -bounds.getHeight());
                    break;
                }
                case 2: {
                    point2D = new Point2D(bounds.getWidth(), 0.0);
                    break;
                }
                case 3: {
                    point2D = new Point2D(0.0, bounds.getHeight());
                    break;
                }
                case 4: {
                    point2D = new Point2D(-bounds.getWidth(), 0.0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            Animation animation = (Animation)AnimationKt.move$default(current, this.duration, destination, null, false, false, null, 44, null);
            Animation[] animationArray = new Animation[1];
            Point2D point2D2 = destination.multiply(-1.0);
            Intrinsics.checkExpressionValueIsNotNull((Object)point2D2, (String)"destination.multiply(-1.0)");
            animationArray[0] = (Animation)AnimationKt.move$default(replacement, this.duration, point2D2, null, true, false, null, 36, null);
            return (Animation)AnimationKt.and$default(animation, animationArray, null, 2, null);
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            return super.stack(replacement, current);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            removed.setTranslateX(0.0);
            removed.setTranslateY(0.0);
        }

        @Override
        @NotNull
        public Slide reversed() {
            Slide slide;
            Slide $receiver = slide = new Slide(this.duration, this.direction.reversed());
            $receiver.setSetup(this.getSetup());
            return slide;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public Slide(@NotNull Duration duration, @NotNull Direction direction) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
            this.duration = duration;
            this.direction = direction;
        }

        public /* synthetic */ Slide(Duration duration, Direction direction, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            this(duration, direction);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ltornadofx/ViewTransition$Cover;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "reversed", "Ltornadofx/ViewTransition$Reveal;", "tornadofx"})
    public static final class Cover
    extends ReversibleViewTransition {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Cover$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    point2D = new Point2D(0.0, bounds.getHeight());
                    break;
                }
                case 2: {
                    point2D = new Point2D(-bounds.getWidth(), 0.0);
                    break;
                }
                case 3: {
                    point2D = new Point2D(0.0, -bounds.getHeight());
                    break;
                }
                case 4: {
                    point2D = new Point2D(bounds.getWidth(), 0.0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            return (Animation)AnimationKt.move$default(replacement, this.duration, destination, null, true, false, null, 36, null);
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            return super.stack(replacement, current);
        }

        @Override
        @NotNull
        public Reveal reversed() {
            Reveal reveal;
            Reveal $receiver = reveal = new Reveal(this.duration, this.direction.reversed());
            $receiver.setSetup(this.getSetup());
            return reveal;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public Cover(@NotNull Duration duration, @NotNull Direction direction) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
            this.duration = duration;
            this.direction = direction;
        }

        public /* synthetic */ Cover(Duration duration, Direction direction, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            this(duration, direction);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Ltornadofx/ViewTransition$Reveal;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "Ltornadofx/ViewTransition$Cover;", "tornadofx"})
    public static final class Reveal
    extends ReversibleViewTransition {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Reveal$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    point2D = new Point2D(0.0, -bounds.getHeight());
                    break;
                }
                case 2: {
                    point2D = new Point2D(bounds.getWidth(), 0.0);
                    break;
                }
                case 3: {
                    point2D = new Point2D(0.0, bounds.getHeight());
                    break;
                }
                case 4: {
                    point2D = new Point2D(-bounds.getWidth(), 0.0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            return (Animation)AnimationKt.move$default(current, this.duration, destination, null, false, false, null, 44, null);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            removed.setTranslateX(0.0);
            removed.setTranslateY(0.0);
        }

        @Override
        @NotNull
        public Cover reversed() {
            Cover cover;
            Cover $receiver = cover = new Cover(this.duration, this.direction.reversed());
            $receiver.setSetup(this.getSetup());
            return cover;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public Reveal(@NotNull Duration duration, @NotNull Direction direction) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
            this.duration = duration;
            this.direction = direction;
        }

        public /* synthetic */ Reveal(Duration duration, Direction direction, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            this(duration, direction);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ltornadofx/ViewTransition$Metro;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "distancePercentage", "", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;D)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDistancePercentage", "()D", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "tornadofx"})
    public static final class Metro
    extends ReversibleViewTransition {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;
        private final double distancePercentage;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Metro$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    point2D = new Point2D(0.0, -bounds.getHeight() * this.distancePercentage);
                    break;
                }
                case 2: {
                    point2D = new Point2D(bounds.getWidth() * this.distancePercentage, 0.0);
                    break;
                }
                case 3: {
                    point2D = new Point2D(0.0, bounds.getHeight() * this.distancePercentage);
                    break;
                }
                case 4: {
                    point2D = new Point2D(-bounds.getWidth() * this.distancePercentage, 0.0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            double opacity = 0.0;
            Point2D scale = new Point2D(1.0, 1.0);
            Duration duration = this.duration.divide(2.0);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"duration.divide(2.0)");
            Animation animation = (Animation)AnimationKt.transform$default(current, duration, destination, 0.0, scale, opacity, null, false, false, null, 352, null);
            Animation[] animationArray = new Animation[1];
            Duration duration2 = this.duration.divide(2.0);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"duration.divide(2.0)");
            Point2D point2D2 = destination.multiply(-1.0);
            Intrinsics.checkExpressionValueIsNotNull((Object)point2D2, (String)"destination.multiply(-1.0)");
            animationArray[0] = (Animation)AnimationKt.transform$default(replacement, duration2, point2D2, 0.0, scale, opacity, null, true, false, null, 288, null);
            return (Animation)AnimationKt.then$default(animation, animationArray, null, 2, null);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            removed.setTranslateX(0.0);
            removed.setTranslateY(0.0);
            removed.setOpacity(1.0);
        }

        @Override
        @NotNull
        public Metro reversed() {
            Metro metro;
            Metro $receiver = metro = new Metro(this.duration, this.direction.reversed(), this.distancePercentage);
            $receiver.setSetup(this.getSetup());
            return metro;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public final double getDistancePercentage() {
            return this.distancePercentage;
        }

        public Metro(@NotNull Duration duration, @NotNull Direction direction, double distancePercentage) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
            this.duration = duration;
            this.direction = direction;
            this.distancePercentage = distancePercentage;
        }

        public /* synthetic */ Metro(Duration duration, Direction direction, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            if ((n & 4) != 0) {
                d = 0.1;
            }
            this(duration, direction, d);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ltornadofx/ViewTransition$Swap;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "scale", "Ljavafx/geometry/Point2D;", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;Ljavafx/geometry/Point2D;)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDuration", "()Ljavafx/util/Duration;", "getScale", "()Ljavafx/geometry/Point2D;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "tornadofx"})
    public static final class Swap
    extends ReversibleViewTransition {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;
        @NotNull
        private final Point2D scale;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Swap$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    point2D = new Point2D(0.0, -bounds.getHeight() * 0.5);
                    break;
                }
                case 2: {
                    point2D = new Point2D(bounds.getWidth() * 0.5, 0.0);
                    break;
                }
                case 3: {
                    point2D = new Point2D(0.0, bounds.getHeight() * 0.5);
                    break;
                }
                case 4: {
                    point2D = new Point2D(-bounds.getWidth() * 0.5, 0.0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            Duration halfTime = this.duration.divide(2.0);
            Animation animation = (Animation)AnimationKt.and$default((Animation)AnimationKt.scale$default(current, this.duration, this.scale, null, false, false, null, 44, null), new Animation[]{(Animation)AnimationKt.scale$default(replacement, this.duration, this.scale, null, true, false, null, 36, null)}, null, 2, null);
            Animation[] animationArray = new Animation[1];
            Duration duration = halfTime;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"halfTime");
            Animation animation2 = (Animation)AnimationKt.move$default(current, duration, destination, null, false, false, null, 60, null);
            Animation[] animationArray2 = new Animation[1];
            Duration duration2 = halfTime;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"halfTime");
            Point2D point2D2 = destination.multiply(-1.0);
            Intrinsics.checkExpressionValueIsNotNull((Object)point2D2, (String)"destination.multiply(-1.0)");
            animationArray2[0] = (Animation)AnimationKt.move$default(replacement, duration2, point2D2, null, false, false, null, 60, null);
            Animation animation3 = (Animation)AnimationKt.and(animation2, animationArray2, (Function1<? super ParallelTransition, Unit>)((Function1)new Function1<ParallelTransition, Unit>(this, stack, replacement){
                final /* synthetic */ Swap this$0;
                final /* synthetic */ StackPane $stack;
                final /* synthetic */ Node $replacement;

                public final void invoke(@NotNull ParallelTransition $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    $receiver.setOnFinished((EventHandler)new EventHandler<ActionEvent>(this){
                        final /* synthetic */ create.1 this$0;

                        public final void handle(ActionEvent it) {
                            this.this$0.this$0.moveToTop(this.this$0.$stack, this.this$0.$replacement);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = swap;
                    this.$stack = stackPane;
                    this.$replacement = node;
                    super(1);
                }
            }));
            Animation[] animationArray3 = new Animation[1];
            Duration duration3 = halfTime;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"halfTime");
            Animation animation4 = (Animation)AnimationKt.move$default(current, duration3, new Point2D(0.0, 0.0), null, false, false, null, 60, null);
            Animation[] animationArray4 = new Animation[1];
            Duration duration4 = halfTime;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"halfTime");
            animationArray4[0] = (Animation)AnimationKt.move$default(replacement, duration4, new Point2D(0.0, 0.0), null, false, false, null, 60, null);
            animationArray3[0] = (Animation)AnimationKt.and$default(animation4, animationArray4, null, 2, null);
            animationArray[0] = (Animation)AnimationKt.then$default(animation3, animationArray3, null, 2, null);
            return (Animation)AnimationKt.and$default(animation, animationArray, null, 2, null);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            removed.setTranslateX(0.0);
            removed.setTranslateY(0.0);
            removed.setScaleX(1.0);
            removed.setScaleY(1.0);
        }

        @Override
        @NotNull
        public Swap reversed() {
            Swap swap;
            Swap $receiver = swap = new Swap(this.duration, this.direction.reversed(), this.scale);
            $receiver.setSetup(this.getSetup());
            return swap;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        @NotNull
        public final Point2D getScale() {
            return this.scale;
        }

        public Swap(@NotNull Duration duration, @NotNull Direction direction, @NotNull Point2D scale) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
            Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
            this.duration = duration;
            this.direction = direction;
            this.scale = scale;
        }

        public /* synthetic */ Swap(Duration duration, Direction direction, Point2D point2D, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            if ((n & 4) != 0) {
                point2D = new Point2D(0.75, 0.75);
            }
            this(duration, direction, point2D);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Ltornadofx/ViewTransition$Flip;", "Ltornadofx/ViewTransition;", "duration", "Ljavafx/util/Duration;", "vertical", "", "(Ljavafx/util/Duration;Z)V", "halfTime", "getHalfTime", "()Ljavafx/util/Duration;", "targetAxis", "Ljavafx/geometry/Point3D;", "getTargetAxis", "()Ljavafx/geometry/Point3D;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "tornadofx"})
    public static final class Flip
    extends ViewTransition {
        @NotNull
        private final Duration halfTime;
        @NotNull
        private final Point3D targetAxis;

        @NotNull
        public final Duration getHalfTime() {
            return this.halfTime;
        }

        @NotNull
        public final Point3D getTargetAxis() {
            return this.targetAxis;
        }

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Interpolator interpolator = Interpolator.EASE_IN;
            Intrinsics.checkExpressionValueIsNotNull((Object)interpolator, (String)"Interpolator.EASE_IN");
            Animation animation = (Animation)AnimationKt.rotate$default(current, this.halfTime, 90.0, interpolator, false, false, (Function1)new Function1<RotateTransition, Unit>(this){
                final /* synthetic */ Flip this$0;

                public final void invoke(@NotNull RotateTransition $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    $receiver.setAxis(this.this$0.getTargetAxis());
                }
                {
                    this.this$0 = flip;
                    super(1);
                }
            }, 8, null);
            Animation[] animationArray = new Animation[1];
            Interpolator interpolator2 = Interpolator.EASE_OUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)interpolator2, (String)"Interpolator.EASE_OUT");
            animationArray[0] = (Animation)AnimationKt.rotate(replacement, this.halfTime, 90.0, interpolator2, true, false, (Function1<? super RotateTransition, Unit>)((Function1)new Function1<RotateTransition, Unit>(this){
                final /* synthetic */ Flip this$0;

                public final void invoke(@NotNull RotateTransition $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    $receiver.setAxis(this.this$0.getTargetAxis());
                }
                {
                    this.this$0 = flip;
                    super(1);
                }
            }));
            return (Animation)AnimationKt.then$default(animation, animationArray, null, 2, null);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            removed.setRotate(0.0);
            removed.setRotationAxis(Rotate.Z_AXIS);
            replacement.setRotationAxis(Rotate.Z_AXIS);
        }

        public Flip(@NotNull Duration duration, boolean vertical) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            Duration duration2 = duration.divide(2.0);
            if (duration2 == null) {
                Intrinsics.throwNpe();
            }
            this.halfTime = duration2;
            Point3D point3D = vertical ? Rotate.X_AXIS : Rotate.Y_AXIS;
            if (point3D == null) {
                Intrinsics.throwNpe();
            }
            this.targetAxis = point3D;
        }

        public /* synthetic */ Flip(Duration duration, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(duration, bl);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Ltornadofx/ViewTransition$NewsFlash;", "Ltornadofx/ViewTransition;", "duration", "Ljavafx/util/Duration;", "rotations", "", "(Ljavafx/util/Duration;D)V", "getDuration", "()Ljavafx/util/Duration;", "getRotations", "()D", "create", "Ljavafx/animation/ParallelTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "tornadofx"})
    public static final class NewsFlash
    extends ViewTransition {
        @NotNull
        private final Duration duration;
        private final double rotations;

        @NotNull
        public ParallelTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Point2D point2D = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)point2D, (String)"Point2D.ZERO");
            double d = this.rotations * (double)360;
            Point2D point2D2 = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)point2D2, (String)"Point2D.ZERO");
            Interpolator interpolator = Interpolator.EASE_IN;
            Intrinsics.checkExpressionValueIsNotNull((Object)interpolator, (String)"Interpolator.EASE_IN");
            return AnimationKt.transform$default(replacement, this.duration, point2D, d, point2D2, 1.0, interpolator, true, false, null, 256, null);
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            return super.stack(replacement, current);
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        public final double getRotations() {
            return this.rotations;
        }

        public NewsFlash(@NotNull Duration duration, double rotations) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            this.duration = duration;
            this.rotations = rotations;
        }

        public /* synthetic */ NewsFlash(Duration duration, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                d = 2.0;
            }
            this(duration, d);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Ltornadofx/ViewTransition$Explode;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "scale", "Ljavafx/geometry/Point2D;", "(Ljavafx/util/Duration;Ljavafx/geometry/Point2D;)V", "getDuration", "()Ljavafx/util/Duration;", "getScale", "()Ljavafx/geometry/Point2D;", "create", "Ljavafx/animation/ParallelTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "Ltornadofx/ViewTransition$Implode;", "tornadofx"})
    public static final class Explode
    extends ReversibleViewTransition {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Point2D scale;

        @NotNull
        public ParallelTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Point2D point2D = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)point2D, (String)"Point2D.ZERO");
            return AnimationKt.transform$default(current, this.duration, point2D, 0.0, this.scale, 0.0, null, false, false, null, 352, null);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            removed.setScaleX(1.0);
            removed.setScaleY(1.0);
            removed.setOpacity(1.0);
        }

        @Override
        @NotNull
        public Implode reversed() {
            Implode implode;
            Implode $receiver = implode = new Implode(this.duration, this.scale);
            $receiver.setSetup(this.getSetup());
            return implode;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Point2D getScale() {
            return this.scale;
        }

        public Explode(@NotNull Duration duration, @NotNull Point2D scale) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
            this.duration = duration;
            this.scale = scale;
        }

        public /* synthetic */ Explode(Duration duration, Point2D point2D, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                point2D = new Point2D(2.0, 2.0);
            }
            this(duration, point2D);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ltornadofx/ViewTransition$Implode;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "scale", "Ljavafx/geometry/Point2D;", "(Ljavafx/util/Duration;Ljavafx/geometry/Point2D;)V", "getDuration", "()Ljavafx/util/Duration;", "getScale", "()Ljavafx/geometry/Point2D;", "create", "Ljavafx/animation/ParallelTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "reversed", "Ltornadofx/ViewTransition$Explode;", "tornadofx"})
    public static final class Implode
    extends ReversibleViewTransition {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Point2D scale;

        @NotNull
        public ParallelTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Point2D point2D = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)point2D, (String)"Point2D.ZERO");
            return AnimationKt.transform$default(replacement, this.duration, point2D, 0.0, this.scale, 0.0, null, true, false, null, 288, null);
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
            return super.stack(replacement, current);
        }

        @Override
        @NotNull
        public Explode reversed() {
            Explode explode;
            Explode $receiver = explode = new Explode(this.duration, this.scale);
            $receiver.setSetup(this.getSetup());
            return explode;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Point2D getScale() {
            return this.scale;
        }

        public Implode(@NotNull Duration duration, @NotNull Point2D scale) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
            this.duration = duration;
            this.scale = scale;
        }

        public /* synthetic */ Implode(Duration duration, Point2D point2D, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                point2D = new Point2D(2.0, 2.0);
            }
            this(duration, point2D);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R:\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR:\u0010\u000b\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Ltornadofx/ViewTransition$Companion;", "", "()V", "SlideIn", "Lkotlin/Function3;", "Ltornadofx/UIComponent;", "Lkotlin/Function0;", "", "SlideIn$annotations", "getSlideIn", "()Lkotlin/jvm/functions/Function3;", "SlideOut", "SlideOut$annotations", "getSlideOut", "tornadofx"})
    public static final class Companion {
        @Deprecated(message="Use `Slide(0.2.seconds)`", replaceWith=@ReplaceWith(imports={}, expression="Slide(0.2.seconds)"))
        private static /* synthetic */ void SlideIn$annotations() {
        }

        @NotNull
        public final Function3<UIComponent, UIComponent, Function0<Unit>, Unit> getSlideIn() {
            return SlideIn;
        }

        @Deprecated(message="Use `Slide(0.2.seconds, Direction.LEFT)`", replaceWith=@ReplaceWith(imports={}, expression="Slide(0.2.seconds, Direction.RIGHT)"))
        private static /* synthetic */ void SlideOut$annotations() {
        }

        @NotNull
        public final Function3<UIComponent, UIComponent, Function0<Unit>, Unit> getSlideOut() {
            return SlideOut;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

