/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tornadofx.FilterHandler;
import tornadofx.FilterInputTextHandler$WhenMappings;
import tornadofx.Resettable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltornadofx/FilterInputTextHandler;", "Ljavafx/event/EventHandler;", "Ljavafx/scene/input/KeyEvent;", "Ltornadofx/Resettable;", "editor", "Ljavafx/scene/control/TextField;", "filterHandler", "Ltornadofx/FilterHandler;", "(Ljavafx/scene/control/TextField;Ltornadofx/FilterHandler;)V", "getEditor", "()Ljavafx/scene/control/TextField;", "getFilterHandler", "()Ltornadofx/FilterHandler;", "lastText", "", "handle", "", "event", "reset", "tornadofx"})
public final class FilterInputTextHandler
implements EventHandler<KeyEvent>,
Resettable {
    private String lastText;
    @NotNull
    private final TextField editor;
    @NotNull
    private final FilterHandler filterHandler;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(@NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String text2 = this.editor.getText();
        boolean inputChanged = Intrinsics.areEqual((Object)this.lastText, (Object)text2) ^ true;
        String string2 = text2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
        this.lastText = string2;
        KeyCode code = event.getCode();
        boolean isControlDown = event.isControlDown();
        boolean isShiftDown = event.isShiftDown();
        int caretPosition = this.editor.getCaretPosition();
        if (isControlDown) {
            KeyCode keyCode = code;
            if (keyCode == null) return;
            switch (FilterInputTextHandler$WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (isShiftDown) {
            KeyCode keyCode = code;
            if (keyCode != null) {
                switch (FilterInputTextHandler$WhenMappings.$EnumSwitchMapping$1[keyCode.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return;
                    }
                }
            }
        }
        KeyCode keyCode = code;
        if (keyCode != null) {
            switch (FilterInputTextHandler$WhenMappings.$EnumSwitchMapping$2[keyCode.ordinal()]) {
                case 1: 
                case 2: {
                    if (this.filterHandler.showSuggestion()) return;
                    this.editor.positionCaret(text2.length());
                    return;
                }
                case 3: {
                    this.filterHandler.hideSuggestion();
                    return;
                }
                case 4: {
                    this.filterHandler.validateSelection();
                    return;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return;
                }
            }
        }
        if (!inputChanged) return;
        this.filterHandler.handleFilterChange(text2);
        this.editor.setText(text2);
        this.editor.positionCaret(caretPosition);
    }

    @Override
    public void reset() {
        this.lastText = "";
    }

    @NotNull
    public final TextField getEditor() {
        return this.editor;
    }

    @NotNull
    public final FilterHandler getFilterHandler() {
        return this.filterHandler;
    }

    public FilterInputTextHandler(@NotNull TextField editor, @NotNull FilterHandler filterHandler2) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)filterHandler2, (String)"filterHandler");
        this.editor = editor;
        this.filterHandler = filterHandler2;
        this.lastText = "";
    }
}

