package tornadofx

class MultiApp: App(Loader::class) {
    override fun shouldShowPrimaryStage() = false

    override fun onBeforeShow(view: UIComponent) {
        val viewType = when (parameters.named["initialView"]) {
            "view1" -> View1::class
            "view2" -> View2::class
            else -> View1::class
        }

        // Put whatever you want into the scope after creating it here
        val newScope = Scope()

        // Find the view and open it in the new scope
        find(viewType, newScope).openWindow()
    }
}

class Loader : View() {
    override val root = pane()

}

class View1 : View("View 1") {
    override val root = pane()
}

class View2 : View("View 2") {
    override val root = pane()
}