/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.DataGrid;
import tornadofx.DataGridCell;
import tornadofx.DataGridRow;
import tornadofx.DataGridSkin;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0006\u0010\u0010\u001a\u00020\rJ\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0015\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\u001c\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\n\u0010\u001e\u001a\u00020\u001f\"\u00020\nH\u0016J\b\u0010 \u001a\u00020\rH\u0016J\b\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020\rH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ltornadofx/DataGridSelectionModel;", "T", "Ljavafx/scene/control/MultipleSelectionModel;", "dataGrid", "Ltornadofx/DataGrid;", "(Ltornadofx/DataGrid;)V", "getDataGrid", "()Ltornadofx/DataGrid;", "selectedIndicies", "Ljavafx/collections/ObservableList;", "", "selectedItems", "clearAndSelect", "", "index", "clearSelection", "clearSelectionAndReapply", "getCellAt", "Ltornadofx/DataGridCell;", "getSelectedIndices", "getSelectedItems", "isEmpty", "", "isSelected", "select", "obj", "(Ljava/lang/Object;)V", "selectAll", "selectFirst", "selectIndices", "indices", "", "selectLast", "selectNext", "selectPrevious", "tornadofx"})
public final class DataGridSelectionModel<T>
extends MultipleSelectionModel<T> {
    private final ObservableList<Integer> selectedIndicies;
    private final ObservableList<T> selectedItems;
    @NotNull
    private final DataGrid<T> dataGrid;

    @Nullable
    public final DataGridCell<T> getCellAt(int index) {
        Skin skin = this.dataGrid.getSkin();
        if (skin == null) {
            throw new TypeCastException("null cannot be cast to non-null type tornadofx.DataGridSkin<T>");
        }
        DataGridSkin skin2 = (DataGridSkin)skin;
        int cellsPerRow = skin2.computeMaxCellsInRow();
        int rowIndex = index / cellsPerRow;
        DataGridRow dataGridRow = skin2.getRow(rowIndex);
        if (dataGridRow == null) {
            return null;
        }
        DataGridRow row2 = dataGridRow;
        int indexInRow = index - rowIndex * cellsPerRow;
        ObservableList children = row2.getChildrenUnmodifiable();
        return children.size() > indexInRow ? (DataGridCell)((Object)children.get(indexInRow)) : null;
    }

    public void selectPrevious() {
        this.select(this.getSelectedIndex() - 1);
    }

    public void selectFirst() {
        this.select(0);
    }

    public void selectLast() {
        this.select(CollectionsKt.getLastIndex((List)((List)this.dataGrid.getItems())));
    }

    @NotNull
    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndicies;
    }

    public void clearAndSelect(int index) {
        this.selectedIndicies.clear();
        this.selectedItems.clear();
        this.select(index);
    }

    @NotNull
    public ObservableList<T> getSelectedItems() {
        return this.selectedItems;
    }

    public void selectNext() {
        this.select(this.getSelectedIndex() + 1);
    }

    /*
     * WARNING - void declaration
     */
    public void selectAll() {
        this.selectedIndicies.clear();
        this.selectedItems.clear();
        Iterable $receiver$iv = (Iterable)this.dataGrid.getItems();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void item2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Object t = item$iv;
            int index = n2;
            this.selectedIndicies.add((Object)index);
            this.selectedItems.add((Object)item2);
        }
        this.select(CollectionsKt.getLastIndex((List)((List)this.dataGrid.getItems())));
    }

    public void clearSelection(int index) {
        if (this.selectedIndicies.contains((Object)index)) {
            this.selectedIndicies.remove((Object)index);
            this.selectedItems.remove(this.dataGrid.getItems().get(index));
        }
        if (this.getSelectedIndex() == index) {
            this.setSelectedIndex(-1);
            this.setSelectedItem(null);
        }
    }

    public void clearSelection() {
        this.selectedIndicies.clear();
        this.selectedItems.clear();
        this.setSelectedItem(null);
        this.setSelectedIndex(-1);
    }

    public boolean isEmpty() {
        return this.selectedIndicies.isEmpty();
    }

    public void selectIndices(int index, int ... indices) {
        int[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)indices, (String)"indices");
        this.select(index);
        int[] nArray = $receiver$iv = indices;
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            int element$iv;
            int it = element$iv = nArray[j];
            this.select(it);
        }
    }

    public boolean isSelected(int index) {
        return this.selectedIndicies.contains((Object)index);
    }

    public void select(T obj) {
        int index = this.dataGrid.getItems().indexOf(obj);
        this.select(index);
    }

    public void select(int index) {
        int n = index;
        if (0 > n || ((Collection)this.dataGrid.getItems()).size() <= n) {
            return;
        }
        this.setSelectedIndex(index);
        this.setSelectedItem(this.dataGrid.getItems().get(index));
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            CollectionsKt.removeAll((List)((List)this.selectedIndicies), (Function1)((Function1)new Function1<Integer, Boolean>(index){
                final /* synthetic */ int $index;

                public final boolean invoke(Integer it) {
                    Integer n = it;
                    return n == null || n != this.$index;
                }
                {
                    this.$index = n;
                    super(1);
                }
            }));
            CollectionsKt.removeAll((List)((List)this.selectedItems), (Function1)new Function1<T, Boolean>(this){
                final /* synthetic */ DataGridSelectionModel this$0;

                public final boolean invoke(T it) {
                    return Intrinsics.areEqual(it, (Object)this.this$0.getSelectedItem()) ^ true;
                }
                {
                    this.this$0 = dataGridSelectionModel;
                    super(1);
                }
            });
        }
        if (!this.selectedIndicies.contains((Object)index)) {
            this.selectedIndicies.add((Object)index);
            this.selectedItems.add(this.getSelectedItem());
            this.dataGrid.getFocusModel().focus(index);
        }
    }

    public final void clearSelectionAndReapply() {
        List currentItems = CollectionsKt.toList((Iterable)((Iterable)this.selectedItems));
        List currentIndexes = CollectionsKt.toList((Iterable)((Iterable)this.selectedIndicies));
        Map selectedItemsToIndex = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)currentItems, (Iterable)currentIndexes));
        this.clearSelection();
        for (Object item2 : currentItems) {
            int index = this.dataGrid.getItems().indexOf(item2);
            if (index > -1) {
                this.select(index);
                continue;
            }
            Object v = selectedItemsToIndex.get(item2);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            this.select(((Number)v).intValue());
        }
    }

    @NotNull
    public final DataGrid<T> getDataGrid() {
        return this.dataGrid;
    }

    public DataGridSelectionModel(@NotNull DataGrid<T> dataGrid) {
        Intrinsics.checkParameterIsNotNull(dataGrid, (String)"dataGrid");
        this.dataGrid = dataGrid;
        ObservableList observableList = FXCollections.observableArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"FXCollections.observableArrayList()");
        this.selectedIndicies = observableList;
        ObservableList observableList2 = FXCollections.observableArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList2, (String)"FXCollections.observableArrayList()");
        this.selectedItems = observableList2;
        ListChangeListener selectedIndicesListener2 = (ListChangeListener)new ListChangeListener<Integer>(this){
            final /* synthetic */ DataGridSelectionModel this$0;

            public final void onChanged(ListChangeListener.Change<? extends Integer> c) {
                while (c.next()) {
                    DataGridCell<T> cell;
                    Integer index;
                    Iterable $receiver$iv;
                    if (c.wasAdded()) {
                        ListChangeListener.Change<? extends Integer> change = c;
                        Intrinsics.checkExpressionValueIsNotNull(change, (String)"c");
                        List list = change.getAddedSubList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"c.addedSubList");
                        $receiver$iv = list;
                        for (T element$iv : $receiver$iv) {
                            Integer n = index = (Integer)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"index");
                            cell = this.this$0.getCellAt(n);
                            if (cell == null || cell.isSelected()) continue;
                            cell.setUpdating(true);
                            cell.updateSelected(true);
                            cell.doUpdateItem$tornadofx();
                            cell.setUpdating(false);
                        }
                    }
                    if (!c.wasRemoved()) continue;
                    ListChangeListener.Change<? extends Integer> change = c;
                    Intrinsics.checkExpressionValueIsNotNull(change, (String)"c");
                    List list = change.getRemoved();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"c.removed");
                    $receiver$iv = list;
                    for (T element$iv : $receiver$iv) {
                        Integer n = index = (Integer)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"index");
                        cell = this.this$0.getCellAt(n);
                        if (cell == null || !cell.isSelected()) continue;
                        cell.setUpdating(true);
                        cell.updateSelected(false);
                        cell.doUpdateItem$tornadofx();
                        cell.setUpdating(false);
                    }
                }
            }
            {
                this.this$0 = dataGridSelectionModel;
            }
        };
        this.getSelectedIndices().addListener(selectedIndicesListener2);
    }

    public static final /* synthetic */ void access$setSelectedItem(DataGridSelectionModel $this, Object p0) {
        $this.setSelectedItem(p0);
    }
}

