/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.Collection;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tornadofx.CSSKt;
import tornadofx.JsonBuilder;
import tornadofx.KeyboardKey;
import tornadofx.KeyboardRow;
import tornadofx.KeyboardSkin;
import tornadofx.KeyboardStyles;
import tornadofx.PropertiesKt;
import tornadofx.SpacerKeyboardKey;
import tornadofx.Stylesheet;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0000\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\n \u0006*\u0004\u0018\u00010\u001f0\u001fH\u0016J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001b\u0010$\u001a\u00020\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0000\u00a2\u0006\u0002\b&J\u001f\u0010'\u001a\u00020\u00052\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0)\u00a2\u0006\u0002\b*J\u0006\u0010+\u001a\u00020#J\u0006\u0010,\u001a\u00020\u001fR5\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR+\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Ltornadofx/KeyboardLayout;", "Ljavafx/scene/control/Control;", "()V", "rows", "Ljavafx/collections/ObservableList;", "Ltornadofx/KeyboardRow;", "kotlin.jvm.PlatformType", "getRows", "()Ljavafx/collections/ObservableList;", "<set-?>", "", "unitSize", "getUnitSize", "()D", "setUnitSize", "(D)V", "unitSize$delegate", "Ljavafx/beans/property/SimpleDoubleProperty;", "unitSizeProperty", "Ljavafx/beans/property/SimpleDoubleProperty;", "getUnitSizeProperty", "()Ljavafx/beans/property/SimpleDoubleProperty;", "addKeys", "", "added", "", "Ltornadofx/KeyboardKey;", "addKeys$tornadofx", "createDefaultSkin", "Ltornadofx/KeyboardSkin;", "getUserAgentStylesheet", "", "load", "", "json", "Ljavax/json/JsonObject;", "removeKeys", "removed", "removeKeys$tornadofx", "row", "op", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "toJSON", "toKeyboardLayoutEditorFormat", "tornadofx"})
public final class KeyboardLayout
extends Control {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ObservableList<KeyboardRow> rows = FXCollections.observableArrayList();
    @NotNull
    private final SimpleDoubleProperty unitSizeProperty;
    @NotNull
    private final SimpleDoubleProperty unitSize$delegate = this.unitSizeProperty = new SimpleDoubleProperty(50.0);

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KeyboardLayout.class), "unitSize", "getUnitSize()D"))};
    }

    public final ObservableList<KeyboardRow> getRows() {
        return this.rows;
    }

    @NotNull
    public final SimpleDoubleProperty getUnitSizeProperty() {
        return this.unitSizeProperty;
    }

    public final double getUnitSize() {
        return PropertiesKt.getValue((ObservableDoubleValue)this.unitSize$delegate, (Object)this, $$delegatedProperties[0]);
    }

    public final void setUnitSize(double d) {
        PropertiesKt.setValue((DoubleProperty)this.unitSize$delegate, (Object)this, $$delegatedProperties[0], d);
    }

    public String getUserAgentStylesheet() {
        return new KeyboardStyles().getBase64URL().toExternalForm();
    }

    @NotNull
    protected KeyboardSkin createDefaultSkin() {
        return new KeyboardSkin(this);
    }

    @NotNull
    public final KeyboardRow row(@NotNull Function1<? super KeyboardRow, Unit> op) {
        KeyboardRow keyboardRow;
        Intrinsics.checkParameterIsNotNull(op, (String)"op");
        KeyboardRow $receiver = keyboardRow = new KeyboardRow(this);
        this.rows.add((Object)$receiver);
        op.invoke((Object)$receiver);
        return keyboardRow;
    }

    /*
     * WARNING - void declaration
     */
    public final void load(@NotNull JsonObject json) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        JsonArray jsonArray2 = json.getJsonArray("rows");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray2, (String)"json.getJsonArray(\"rows\")");
        Iterable iterable = (Iterable)jsonArray2;
        Collection destination$iv = (Collection)this.rows;
        for (Object item$iv : $receiver$iv) {
            void it;
            JsonValue jsonValue = (JsonValue)item$iv;
            Collection collection = destination$iv;
            void v1 = it;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.json.JsonObject");
            }
            KeyboardRow keyboardRow = KeyboardRow.Companion.fromJSON(this, (JsonObject)v1);
            collection.add(keyboardRow);
        }
    }

    @NotNull
    public final JsonObject toJSON() {
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        String string2 = "rows";
        JsonBuilder jsonBuilder = new JsonBuilder();
        JsonArrayBuilder jsonRows = jsonArrayBuilder;
        ObservableList<KeyboardRow> observableList = this.rows;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"rows");
        Iterable $receiver$iv = (Iterable)observableList;
        for (Object element$iv : $receiver$iv) {
            KeyboardRow it = (KeyboardRow)element$iv;
            jsonRows.add((JsonValue)it.toJSON());
        }
        JsonArray jsonArray2 = jsonRows.build();
        return jsonBuilder.add(string2, jsonArray2).build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toKeyboardLayoutEditorFormat() {
        StringBuilder output = new StringBuilder();
        ObservableList<KeyboardRow> observableList = this.rows;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"rows");
        Iterable $receiver$iv = (Iterable)observableList;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void row2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            KeyboardRow keyboardRow = (KeyboardRow)item$iv;
            int rowIndex = n2;
            output.append("[");
            ObservableList<KeyboardKey> observableList2 = row2.getKeys();
            Intrinsics.checkExpressionValueIsNotNull(observableList2, (String)"row.keys");
            Iterable $receiver$iv2 = (Iterable)observableList2;
            int index$iv2 = 0;
            for (Object item$iv2 : $receiver$iv2) {
                void key2;
                int n3;
                if ((n3 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n4 = n3;
                KeyboardKey keyboardKey = (KeyboardKey)((Object)item$iv2);
                int colIndex = n4;
                if (colIndex > 0) {
                    output.append(",");
                }
                if (key2 instanceof SpacerKeyboardKey) {
                    output.append("{x:" + key2.getKeyWidth() + '}');
                    continue;
                }
                if (key2.getKeyWidth() != 1.0 || key2.getKeyHeight() != 1.0) {
                    output.append("{");
                    if (key2.getKeyWidth() != 1.0) {
                        output.append("w:" + key2.getKeyWidth());
                    }
                    if (key2.getKeyHeight() != 1.0) {
                        output.append("h:" + key2.getKeyHeight());
                    }
                    output.append("},");
                }
                StringBuilder stringBuilder = new StringBuilder().append('\"');
                void v3 = key2;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"key");
                String string2 = v3.getText();
                if (string2 == null || (string2 = StringsKt.replace$default((String)string2, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null)) == null) {
                    string2 = "";
                }
                output.append(stringBuilder.append(string2).append('\"').toString());
            }
            output.append("]");
            if (rowIndex < this.rows.size() - 1) {
                output.append(",");
            }
            output.append("\n");
        }
        String string3 = output.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"output.toString()");
        return string3;
    }

    public final boolean addKeys$tornadofx(@NotNull List<? extends KeyboardKey> added) {
        Intrinsics.checkParameterIsNotNull(added, (String)"added");
        return this.getChildren().addAll((Collection)added);
    }

    public final boolean removeKeys$tornadofx(@NotNull List<? extends KeyboardKey> removed) {
        Intrinsics.checkParameterIsNotNull(removed, (String)"removed");
        return this.getChildren().removeAll((Collection)removed);
    }

    public KeyboardLayout() {
        CSSKt.addClass(this, Stylesheet.Companion.getKeyboard());
    }
}

