/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.HttpClientRequest;
import tornadofx.Rest;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Ltornadofx/HttpClientEngine;", "Ltornadofx/Rest$Engine;", "rest", "Ltornadofx/Rest;", "(Ltornadofx/Rest;)V", "client", "Lorg/apache/http/impl/client/CloseableHttpClient;", "getClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "setClient", "(Lorg/apache/http/impl/client/CloseableHttpClient;)V", "context", "Lorg/apache/http/client/protocol/HttpClientContext;", "getContext", "()Lorg/apache/http/client/protocol/HttpClientContext;", "setContext", "(Lorg/apache/http/client/protocol/HttpClientContext;)V", "getRest", "()Ltornadofx/Rest;", "request", "Ltornadofx/HttpClientRequest;", "seq", "", "method", "Ltornadofx/Rest$Request$Method;", "uri", "Ljava/net/URI;", "entity", "", "reset", "", "setBasicAuth", "username", "", "password", "tornadofx"})
public final class HttpClientEngine
extends Rest.Engine {
    @NotNull
    public CloseableHttpClient client;
    @NotNull
    public HttpClientContext context;
    @NotNull
    private final Rest rest;

    @NotNull
    public final CloseableHttpClient getClient() {
        CloseableHttpClient closeableHttpClient = this.client;
        if (closeableHttpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        return closeableHttpClient;
    }

    public final void setClient(@NotNull CloseableHttpClient closeableHttpClient) {
        Intrinsics.checkParameterIsNotNull((Object)closeableHttpClient, (String)"<set-?>");
        this.client = closeableHttpClient;
    }

    @NotNull
    public final HttpClientContext getContext() {
        HttpClientContext httpClientContext = this.context;
        if (httpClientContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        return httpClientContext;
    }

    public final void setContext(@NotNull HttpClientContext httpClientContext) {
        Intrinsics.checkParameterIsNotNull((Object)httpClientContext, (String)"<set-?>");
        this.context = httpClientContext;
    }

    @Override
    @NotNull
    public HttpClientRequest request(long seq, @NotNull Rest.Request.Method method, @NotNull URI uri, @Nullable Object entity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        CloseableHttpClient closeableHttpClient = this.client;
        if (closeableHttpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        return new HttpClientRequest(this, closeableHttpClient, seq, method, uri, entity);
    }

    @Override
    public void setBasicAuth(@NotNull String username, @NotNull String password) {
        BasicCredentialsProvider basicCredentialsProvider;
        String scheme;
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        if (this.rest.getBaseURI() == null) {
            throw (Throwable)new IllegalArgumentException("You must configure the baseURI first.");
        }
        URI uri = URI.create(this.rest.getBaseURI());
        String string = scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        int port = uri.getPort() > -1 ? uri.getPort() : (Intrinsics.areEqual((Object)scheme, (Object)"http") ? 80 : 443);
        HttpHost host = new HttpHost(uri.getHost(), port, scheme);
        BasicCredentialsProvider $receiver = basicCredentialsProvider = new BasicCredentialsProvider();
        $receiver.setCredentials(new AuthScope(host), (Credentials)new UsernamePasswordCredentials(username, password));
        BasicCredentialsProvider credsProvider = basicCredentialsProvider;
        HttpClientContext httpClientContext = this.context;
        if (httpClientContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        httpClientContext.setAuthCache((AuthCache)new BasicAuthCache());
        HttpClientContext httpClientContext2 = this.context;
        if (httpClientContext2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        httpClientContext2.getAuthCache().put(host, (AuthScheme)new BasicScheme());
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"HttpClients.custom().set\u2026er(credsProvider).build()");
        this.client = closeableHttpClient;
    }

    @Override
    public void reset() {
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"HttpClientBuilder.create().build()");
        this.client = closeableHttpClient;
        HttpClientContext httpClientContext = HttpClientContext.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpClientContext, (String)"HttpClientContext.create()");
        this.context = httpClientContext;
    }

    @NotNull
    public final Rest getRest() {
        return this.rest;
    }

    public HttpClientEngine(@NotNull Rest rest) {
        Intrinsics.checkParameterIsNotNull((Object)rest, (String)"rest");
        this.rest = rest;
        this.reset();
    }
}

