/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tornadofx.AuthContext;
import tornadofx.FX;
import tornadofx.Rest;
import tornadofx.RestKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u001a\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010-\u001a\u00020'2\u0006\u0010&\u001a\u00020'H\u0016R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\nR\u001a\u0010 \u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\b\"\u0004\b\"\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\b\u00a8\u0006/"}, d2={"Ltornadofx/DigestAuthContext;", "Ltornadofx/AuthContext;", "username", "", "password", "(Ljava/lang/String;Ljava/lang/String;)V", "algorithm", "getAlgorithm", "()Ljava/lang/String;", "setAlgorithm", "(Ljava/lang/String;)V", "digest", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "getDigest", "()Ljava/security/MessageDigest;", "setDigest", "(Ljava/security/MessageDigest;)V", "nonce", "getNonce", "setNonce", "nonceCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "getNonceCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "opaque", "getOpaque", "setOpaque", "getPassword", "qop", "getQop", "setQop", "realm", "getRealm", "setRealm", "getUsername", "extractNextNonce", "", "response", "Ltornadofx/Rest$Response;", "generateAuthHeader", "request", "Ltornadofx/Rest$Request;", "generateCnonce", "interceptRequest", "interceptResponse", "Companion", "tornadofx"})
public final class DigestAuthContext
implements AuthContext {
    @NotNull
    private final AtomicLong nonceCounter;
    @NotNull
    private String nonce;
    @NotNull
    private String realm;
    @NotNull
    private String qop;
    @NotNull
    private String opaque;
    @NotNull
    private String algorithm;
    private MessageDigest digest;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @NotNull
    private static final List<String> QuotedStringParameters;
    public static final Companion Companion;

    @NotNull
    public final AtomicLong getNonceCounter() {
        return this.nonceCounter;
    }

    @NotNull
    public final String getNonce() {
        return this.nonce;
    }

    public final void setNonce(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.nonce = string;
    }

    @NotNull
    public final String getRealm() {
        return this.realm;
    }

    public final void setRealm(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.realm = string;
    }

    @NotNull
    public final String getQop() {
        return this.qop;
    }

    public final void setQop(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.qop = string;
    }

    @NotNull
    public final String getOpaque() {
        return this.opaque;
    }

    public final void setOpaque(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.opaque = string;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void setAlgorithm(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.algorithm = string;
    }

    public final MessageDigest getDigest() {
        return this.digest;
    }

    public final void setDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    @Override
    public void interceptRequest(@NotNull Rest.Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        CharSequence charSequence = this.nonce;
        if (!StringsKt.isBlank((CharSequence)charSequence) && request.getHeader("Authorization") == null) {
            request.addHeader("Authorization", this.generateAuthHeader(request, null));
        }
    }

    private final String generateCnonce(MessageDigest digest) {
        return RestKt.concat(digest, String.valueOf(System.nanoTime()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Rest.Response interceptResponse(@NotNull Rest.Response response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.extractNextNonce(response);
        if (response.getStatusCode() != 401 || response.getRequest().getProperties().get("Authorization-Retried") != null) {
            return response;
        }
        Map<String, String> params = RestKt.getDigestParams(response);
        if (params != null) {
            boolean bl;
            Object object;
            String string = params.get("stale");
            if (string != null) {
                object = string;
                bl = Boolean.parseBoolean((String)object);
            } else {
                bl = true;
            }
            if (bl) {
                Collection<String> collection;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                FX.Companion.getLog().fine(new Supplier<String>(params){
                    final /* synthetic */ Map $params;

                    @NotNull
                    public final String get() {
                        return "Digest Challenge: " + this.$params;
                    }
                    {
                        this.$params = map;
                    }
                });
                String string2 = params.get("algorithm");
                if (string2 == null) {
                    string2 = "MD5";
                }
                this.algorithm = string2;
                this.digest = MessageDigest.getInstance(StringsKt.removeSuffix((String)this.algorithm, (CharSequence)"-sess"));
                String string3 = params.get("realm");
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                this.realm = string3;
                String string4 = params.get("nonce");
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                this.nonce = string4;
                String string5 = params.get("opaque");
                if (string5 == null) {
                    string5 = "";
                }
                this.opaque = string5;
                this.nonceCounter.set(0L);
                String string6 = params.get("qop");
                if (string6 == null) {
                    string6 = "";
                }
                object = StringsKt.split$default((CharSequence)string6, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                DigestAuthContext digestAuthContext = this;
                Object object2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void p1;
                    void var9_10;
                    String string7 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    void v7 = var9_10 = p1;
                    if (v7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string8 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v7))).toString();
                    collection.add(string8);
                }
                collection = (List)destination$iv$iv;
                $receiver$iv = collection;
                object2 = $receiver$iv;
                Object object3 = new Comparator<String>(){

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public int compare(Object a, Object b) {
                        String it = (String)a;
                        Comparable comparable = Integer.valueOf(it.length());
                        it = (String)b;
                        Comparable comparable2 = comparable;
                        Integer n = it.length();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                collection = CollectionsKt.sortedWith((Iterable)object2, (Comparator)object3);
                digestAuthContext.qop = (String)CollectionsKt.first((List)CollectionsKt.reversed((Iterable)collection));
                Rest.Request request = response.getRequest();
                request.reset();
                request.addHeader("Authorization", this.generateAuthHeader(request, response));
                object2 = request.getProperties();
                object3 = "Authorization-Retried";
                Boolean bl2 = true;
                object2.put(object3, bl2);
                return request.execute();
            }
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private final void extractNextNonce(Rest.Response response) {
        String authInfo = response.header("Authentication-Info");
        if (authInfo != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)authInfo, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void value2;
                void name;
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                Object object = new String[]{"="};
                boolean bl = false;
                int n = 2;
                List list = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])object, (boolean)bl, (int)n, (int)2, null);
                object = list;
                String string2 = (String)object.get(0);
                object = list;
                String string3 = (String)object.get(1);
                list = null;
                Pair pair = TuplesKt.to((Object)name, (Object)value2);
                collection.add(pair);
            }
            Map params = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            String nextNonce = (String)params.get("nextnonce");
            if (nextNonce != null) {
                this.nonceCounter.set(0L);
                this.nonce = nextNonce;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final String generateAuthHeader(Rest.Request request, Rest.Response response) {
        block14: {
            v0 = this.digest;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"digest");
            cnonce = this.generateCnonce(v0);
            path = request.getUri().getPath();
            nc = StringsKt.padStart((String)Integer.toHexString((int)this.nonceCounter.incrementAndGet()), (int)8, (char)'0');
            var7_6 = this.algorithm;
            switch (var7_6.hashCode()) {
                case -1459419359: {
                    if (var7_6.equals("MD5-sess")) {
                        v1 = RestKt.concat(this.digest, new String[]{RestKt.concat(this.digest, new String[]{this.username, this.realm, this.password}), this.nonce, cnonce});
                        break;
                    }
                }
                default: {
                    v1 = RestKt.concat(this.digest, new String[]{this.username, this.realm, this.password});
                }
            }
            ha1 = v1;
            var8_8 = this.qop;
            switch (var8_8.hashCode()) {
                case 1431098954: {
                    if (var8_8.equals("auth-int")) {
                        v2 = new String[3];
                        v2[0] = request.getMethod().name();
                        v3 = path;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"path");
                        v2[1] = v3;
                        v4 = new String[1];
                        v5 = response;
                        if (v5 == null || (v5 = v5.text()) == null) {
                            v5 = "";
                        }
                        v4[0] = v5;
                        v2[2] = RestKt.concat(this.digest, v4);
                        v6 = RestKt.concat(this.digest, v2);
                        break;
                    }
                }
                default: {
                    v7 = new String[2];
                    v7[0] = request.getMethod().name();
                    v8 = path;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"path");
                    v7[1] = v8;
                    v6 = RestKt.concat(this.digest, v7);
                }
            }
            ha2 = v6;
            var9_9 = this.qop;
            switch (var9_9.hashCode()) {
                case 3005864: {
                    if (!var9_9.equals("auth")) break;
                    ** GOTO lbl47
                }
                case 1431098954: {
                    if (!var9_9.equals("auth-int")) break;
lbl47:
                    // 2 sources

                    v9 = RestKt.concat(this.digest, new String[]{ha1, this.nonce, String.valueOf(this.nonceCounter.incrementAndGet()), cnonce, this.qop, ha2});
                    break block14;
                }
            }
            v9 = RestKt.concat(this.digest, new String[]{ha1, this.nonce, ha2});
        }
        encoded = v9;
        var11_10 = authParams = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"username", (Object)this.username), TuplesKt.to((Object)"realm", (Object)this.realm), TuplesKt.to((Object)"nonce", (Object)this.nonce), TuplesKt.to((Object)"uri", (Object)path), TuplesKt.to((Object)"response", (Object)encoded), TuplesKt.to((Object)"opaque", (Object)this.opaque), TuplesKt.to((Object)"algorithm", (Object)this.algorithm), TuplesKt.to((Object)"nc", (Object)nc)});
        var22_11 = new StringBuilder().append("Digest ");
        var12_12 = $receiver$iv;
        destination$iv$iv = new ArrayList<E>($receiver$iv.size());
        var14_14 = $receiver$iv$iv;
        var15_15 = var14_14.entrySet().iterator();
        while (var15_15.hasNext()) {
            var17_17 = item$iv$iv = var15_15.next();
            var23_19 = destination$iv$iv;
            q = DigestAuthContext.Companion.getQuotedStringParameters().contains(it.getKey()) != false ? "\"" : "";
            var24_20 = (String)it.getKey() + "=" + q + (String)it.getValue() + q;
            var23_19.add(var24_20);
        }
        var23_19 = (List)destination$iv$iv;
        header = var22_11.append(CollectionsKt.joinToString$default((Iterable)var23_19, null, null, null, (int)0, null, null, (int)63, null)).toString();
        FX.Companion.getLog().fine(new Supplier<String>(header){
            final /* synthetic */ String $header;

            @NotNull
            public final String get() {
                return "Digest Response: " + this.$header;
            }
            {
                this.$header = string;
            }
        });
        return header;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    public DigestAuthContext(@NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.username = username;
        this.password = password;
        this.nonceCounter = new AtomicLong(0L);
        this.nonce = "";
        this.realm = "";
        this.qop = "";
        this.opaque = "";
        this.algorithm = "";
        this.digest = MessageDigest.getInstance("MD5");
    }

    static {
        Companion = new Companion(null);
        QuotedStringParameters = CollectionsKt.listOf((Object[])new String[]{"username", "realm", "nonce", "uri", "response", "cnonce", "opaque"});
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltornadofx/DigestAuthContext$Companion;", "", "()V", "QuotedStringParameters", "", "", "getQuotedStringParameters", "()Ljava/util/List;", "tornadofx"})
    public static final class Companion {
        @NotNull
        public final List<String> getQuotedStringParameters() {
            return QuotedStringParameters;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

