/*
 * Decompiled with CFR 0.152.
 */
package ognl.benchmarks;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import ognl.DefaultMemberAccess;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.SimpleNode;
import ognl.enhance.ExpressionAccessor;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime, Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=1, warmups=1, jvmArgs={"--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/java.lang.reflect=ALL-UNNAMED", "--add-opens=java.base/java.util=ALL-UNNAMED"})
@Warmup(iterations=3, time=1)
@Measurement(iterations=5, time=1, batchSize=2)
public class OgnlPerformanceBenchmarks {
    private OgnlContext context;
    private BenchmarkRootBean root;
    private SimpleNode constantExpression;
    private SimpleNode compiledConstantExpression;
    private SimpleNode singlePropertyExpression;
    private SimpleNode compiledSinglePropertyExpression;
    private SimpleNode propertyNavigationExpression;
    private SimpleNode compiledPropertyNavigationExpression;
    private SimpleNode propertyNavigationAndComparisonExpression;
    private SimpleNode compiledPropertyNavigationAndComparisonExpression;
    private SimpleNode propertyNavigationWithMapExpression;
    private SimpleNode compiledPropertyNavigationWithMapExpression;

    @Setup
    public void setup() {
        try {
            this.context = Ognl.createDefaultContext(null, (MemberAccess)new DefaultMemberAccess(false));
            this.root = new BenchmarkRootBean();
            this.context.put("contextValue", (Object)"cvalue");
            this.constantExpression = (SimpleNode)Ognl.parseExpression((String)"100 + 20 * 5");
            this.compiledConstantExpression = (SimpleNode)Ognl.compileExpression((OgnlContext)this.context, (Object)this.root, (String)"100 + 20 * 5");
            this.singlePropertyExpression = (SimpleNode)Ognl.parseExpression((String)"bean2");
            this.compiledSinglePropertyExpression = (SimpleNode)Ognl.compileExpression((OgnlContext)this.context, (Object)this.root, (String)"bean2");
            this.propertyNavigationExpression = (SimpleNode)Ognl.parseExpression((String)"bean2.bean3.value");
            this.compiledPropertyNavigationExpression = (SimpleNode)Ognl.compileExpression((OgnlContext)this.context, (Object)this.root, (String)"bean2.bean3.value");
            this.propertyNavigationAndComparisonExpression = (SimpleNode)Ognl.parseExpression((String)"bean2.bean3.value <= 24");
            this.compiledPropertyNavigationAndComparisonExpression = (SimpleNode)Ognl.compileExpression((OgnlContext)this.context, (Object)this.root, (String)"bean2.bean3.value <= 24");
            this.propertyNavigationWithMapExpression = (SimpleNode)Ognl.parseExpression((String)"bean2.bean3.map['foo']");
            this.compiledPropertyNavigationWithMapExpression = (SimpleNode)Ognl.compileExpression((OgnlContext)this.context, (Object)this.root, (String)"bean2.bean3.map['foo']");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to setup benchmark", e);
        }
    }

    @Benchmark
    public void constantExpressionInterpreted(Blackhole blackhole) throws OgnlException {
        Object result = Ognl.getValue((Object)this.constantExpression, (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    @Benchmark
    public void constantExpressionCompiled(Blackhole blackhole) {
        Object result = Ognl.getValue((ExpressionAccessor)this.compiledConstantExpression.getAccessor(), (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    @Benchmark
    public void singlePropertyExpressionInterpreted(Blackhole blackhole) throws OgnlException {
        Object result = Ognl.getValue((Object)this.singlePropertyExpression, (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    @Benchmark
    public void singlePropertyExpressionCompiled(Blackhole blackhole) {
        Object result = Ognl.getValue((ExpressionAccessor)this.compiledSinglePropertyExpression.getAccessor(), (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    @Benchmark
    public void propertyNavigationExpressionInterpreted(Blackhole blackhole) throws OgnlException {
        Object result = Ognl.getValue((Object)this.propertyNavigationExpression, (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    @Benchmark
    public void propertyNavigationExpressionCompiled(Blackhole blackhole) {
        Object result = Ognl.getValue((ExpressionAccessor)this.compiledPropertyNavigationExpression.getAccessor(), (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    @Benchmark
    public void propertyNavigationAndComparisonExpressionInterpreted(Blackhole blackhole) throws OgnlException {
        Object result = Ognl.getValue((Object)this.propertyNavigationAndComparisonExpression, (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    @Benchmark
    public void propertyNavigationAndComparisonExpressionCompiled(Blackhole blackhole) {
        Object result = Ognl.getValue((ExpressionAccessor)this.compiledPropertyNavigationAndComparisonExpression.getAccessor(), (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    @Benchmark
    public void propertyNavigationWithMapExpressionInterpreted(Blackhole blackhole) throws OgnlException {
        Object result = Ognl.getValue((Object)this.propertyNavigationWithMapExpression, (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    @Benchmark
    public void propertyNavigationWithMapExpressionCompiled(Blackhole blackhole) {
        Object result = Ognl.getValue((ExpressionAccessor)this.compiledPropertyNavigationWithMapExpression.getAccessor(), (OgnlContext)this.context, (Object)this.root);
        blackhole.consume(result);
    }

    public static class BenchmarkRootBean {
        private BenchmarkNestedBean bean2 = new BenchmarkNestedBean();

        public BenchmarkNestedBean getBean2() {
            return this.bean2;
        }
    }

    public static class BenchmarkLeafBean {
        private int value = 20;
        private String nullValue;
        private int[] indexedValue = new int[100];
        private Map<String, String> map = new HashMap<String, String>();

        public BenchmarkLeafBean() {
            this.map.put("foo", "bar");
        }

        public int getValue() {
            return this.value;
        }

        public void setNullValue(String value) {
            this.nullValue = value;
        }

        public int getIndexedValue(int index) {
            return this.indexedValue[index];
        }

        public Map<String, String> getMap() {
            return this.map;
        }
    }

    public static class BenchmarkNestedBean {
        private BenchmarkLeafBean bean3 = new BenchmarkLeafBean();

        public BenchmarkLeafBean getBean3() {
            return this.bean3;
        }
    }
}

