/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.bc4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import one.cafebabe.bc4j.HolidayMap;
import one.cafebabe.bc4j.Japan;
import org.jetbrains.annotations.NotNull;

class CSVHolidays
extends HolidayMap {
    private final String resourceURL;
    private final String fallbackResource;
    private final String prefix;
    private final Charset charset;

    CSVHolidays(long interval, @NotNull String resourceURL, @NotNull String fallbackResource, @NotNull String prefix, @NotNull Charset charset) {
        this.resourceURL = resourceURL;
        this.fallbackResource = fallbackResource;
        this.prefix = prefix;
        this.charset = charset;
        this.loadHolidays();
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                CSVHolidays.this.loadHolidays();
            }
        }, interval, interval);
    }

    private void loadHolidays() {
        try {
            URLConnection con = new URL(this.resourceURL).openConnection();
            con.setConnectTimeout(30000);
            con.setReadTimeout(5000);
            this.holidayMap = CSVHolidays.load(con.getInputStream(), this.prefix, this.charset);
        }
        catch (IOException e) {
            try {
                this.holidayMap = CSVHolidays.load(Objects.requireNonNull(Japan.class.getResourceAsStream(this.fallbackResource)), this.prefix, this.charset);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static TreeMap<LocalDate, String> load(InputStream is, String prefix, Charset charset) throws IOException {
        int length;
        TreeMap<LocalDate, String> holidayMap = new TreeMap<LocalDate, String>();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(20000);
        byte[] buf = new byte[1024];
        while (-1 != (length = is.read(buf))) {
            outputStream.write(buf, 0, length);
        }
        String result = new String(outputStream.toByteArray(), charset);
        boolean firstLine = true;
        for (String line : result.split("\n")) {
            if (firstLine) {
                firstLine = false;
                continue;
            }
            String[] split = line.split(",");
            LocalDate date = LocalDate.parse(split[0], DateTimeFormatter.ofPattern("yyyy/M/d"));
            String holidayName = split[1].trim();
            holidayMap.put(date, prefix + holidayName);
        }
        return holidayMap;
    }
}

