/*
 * Decompiled with CFR 0.152.
 */
package one.cafebabe.bc4j;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Function;
import one.cafebabe.bc4j.BusinessCalendar;
import one.cafebabe.bc4j.BusinessHourSlot;
import one.cafebabe.bc4j.Holiday;
import one.cafebabe.bc4j.Japan;
import one.cafebabe.bc4j.UnitedStates;
import one.cafebabe.bc4j.\u30d3\u30b8\u30cd\u30b9\u30ab\u30ec\u30f3\u30c0\u30fcBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class \u30d3\u30b8\u30cd\u30b9\u30ab\u30ec\u30f3\u30c0\u30fc {
    private final BusinessCalendar businessCalendar;
    public static final Function<LocalDate, String> \u6b63\u6708\u4e09\u304c\u65e5\u4f11\u696d = BusinessCalendar.JAPAN.CLOSED_ON_NEW_YEARS_HOLIDAYS;
    public static final Japan \u65e5\u672c = Japan.getInstance();
    public static final UnitedStates \u30a2\u30e1\u30ea\u30ab\u5408\u8846\u56fd = UnitedStates.getInstance();
    public static final Function<LocalDate, String> \u5927\u6666\u65e5\u4f11\u696d = BusinessCalendar.JAPAN.CLOSED_ON_NEW_YEARS_EVE;
    public static final Function<LocalDate, String> \u571f\u65e5\u4f11\u696d = BusinessCalendar.CLOSED_ON_SATURDAYS_AND_SUNDAYS;

    \u30d3\u30b8\u30cd\u30b9\u30ab\u30ec\u30f3\u30c0\u30fc(BusinessCalendar businessCalendar) {
        this.businessCalendar = businessCalendar;
    }

    @NotNull
    public static \u30d3\u30b8\u30cd\u30b9\u30ab\u30ec\u30f3\u30c0\u30fcBuilder newBuilder() {
        return new \u30d3\u30b8\u30cd\u30b9\u30ab\u30ec\u30f3\u30c0\u30fcBuilder();
    }

    public boolean is\u795d\u4f11\u65e5(@NotNull LocalDate date) {
        return this.businessCalendar.isHoliday(date);
    }

    public boolean is\u795d\u4f11\u65e5() {
        return this.businessCalendar.isHoliday();
    }

    public boolean is\u55b6\u696d\u65e5(@NotNull LocalDate date) {
        return this.businessCalendar.isBusinessDay(date);
    }

    public boolean is\u55b6\u696d\u65e5() {
        return this.businessCalendar.isBusinessDay();
    }

    public boolean is\u55b6\u696d\u6642\u9593(@NotNull LocalDateTime dateTime) {
        return this.businessCalendar.isBusinessHour(dateTime);
    }

    public boolean is\u55b6\u696d\u6642\u9593() {
        return this.businessCalendar.isBusinessHour();
    }

    @NotNull
    public List<BusinessHourSlot> get\u55b6\u696d\u6642\u9593\u67a0(@NotNull LocalDate \u65e5\u4ed8) {
        return this.businessCalendar.getBusinessHourSlots(\u65e5\u4ed8);
    }

    @NotNull
    public LocalDateTime \u524d\u306e\u55b6\u696d\u7d42\u4e86\u6642\u9593(@NotNull LocalDateTime when) {
        return this.businessCalendar.lastBusinessHourEnd(when);
    }

    @NotNull
    public LocalDateTime \u6b21\u306e\u55b6\u696d\u7d42\u4e86\u6642\u9593(@NotNull LocalDateTime when) {
        return this.businessCalendar.nextBusinessHourEnd(when);
    }

    @NotNull
    public LocalDateTime \u524d\u306e\u55b6\u696d\u958b\u59cb\u6642\u9593(@NotNull LocalDateTime when) {
        return this.businessCalendar.lastBusinessHourStart(when);
    }

    @NotNull
    public LocalDateTime \u6b21\u306e\u55b6\u696d\u958b\u59cb\u6642\u9593(@NotNull LocalDateTime when) {
        return this.businessCalendar.nextBusinessHourStart(when);
    }

    @Nullable
    public Holiday get\u795d\u4f11\u65e5(@NotNull LocalDate date) {
        return this.businessCalendar.getHoliday(date);
    }

    @NotNull
    public LocalDate \u6700\u5f8c\u306e\u55b6\u696d\u65e5(@NotNull LocalDate date) {
        return this.businessCalendar.lastBusinessDay(date);
    }

    @NotNull
    public LocalDate \u6700\u5f8c\u306e\u55b6\u696d\u65e5() {
        return this.businessCalendar.lastBusinessDay();
    }

    @NotNull
    public LocalDate \u6700\u521d\u306e\u55b6\u696d\u65e5(@NotNull LocalDate date) {
        return this.businessCalendar.firstBusinessDay(date);
    }

    @NotNull
    public LocalDate \u6700\u521d\u306e\u55b6\u696d\u65e5() {
        return this.businessCalendar.firstBusinessDay();
    }

    @NotNull
    public Holiday \u6700\u5f8c\u306e\u795d\u4f11\u65e5(@NotNull LocalDate date) {
        return this.businessCalendar.lastHoliday(date);
    }

    @NotNull
    public Holiday \u6700\u5f8c\u306e\u795d\u4f11\u65e5() {
        return this.businessCalendar.lastHoliday();
    }

    @NotNull
    public Holiday \u6700\u521d\u306e\u795d\u4f11\u65e5(@NotNull LocalDate date) {
        return this.businessCalendar.firstHoliday(date);
    }

    @NotNull
    public Holiday \u6700\u521d\u306e\u795d\u4f11\u65e5() {
        return this.businessCalendar.firstHoliday();
    }

    @NotNull
    public List<Holiday> get\u6307\u5b9a\u671f\u9593\u5185\u306e\u795d\u4f11\u65e5(@NotNull LocalDate \u958b\u59cb\u65e5, @NotNull LocalDate \u7d42\u4e86\u65e5) {
        return this.businessCalendar.getHolidaysBetween(\u958b\u59cb\u65e5, \u7d42\u4e86\u65e5);
    }

    @NotNull
    public List<LocalDate> get\u6307\u5b9a\u671f\u9593\u5185\u306e\u55b6\u696d\u65e5(@NotNull LocalDate \u958b\u59cb\u65e5, @NotNull LocalDate \u7d42\u4e86\u65e5) {
        return this.businessCalendar.getBusinessDaysBetween(\u958b\u59cb\u65e5, \u7d42\u4e86\u65e5);
    }

    @NotNull
    public LocalDate get\u5185\u95a3\u5e9c\u516c\u8868\u795d\u4f11\u65e5\u521d\u65e5() {
        return Japan.getCabinetOfficialHolidayDataFirstDay();
    }

    @NotNull
    public LocalDate get\u5185\u95a3\u5e9c\u516c\u8868\u795d\u4f11\u65e5\u6700\u7d42\u65e5() {
        return Japan.getCabinetOfficialHolidayDataLastDay();
    }
}

